/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.event.ServiceStartedEvent;
import io.micronaut.health.CurrentHealthStatus;
import io.micronaut.health.HeartbeatConfiguration;
import io.micronaut.health.HeartbeatEvent;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.scheduling.annotation.Scheduled;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(property="micronaut.heartbeat.enabled", value="true", defaultValue="true"), @Requires(property="micronaut.application.name"), @Requires(beans={EmbeddedServer.class}), @Requires(notEnv={"android"})})
public class HeartbeatTask
implements ApplicationEventListener<ServiceStartedEvent> {
    private AtomicReference<ServiceInstance> eventReference = new AtomicReference();
    private final ApplicationEventPublisher eventPublisher;
    private final HeartbeatConfiguration configuration;
    private final CurrentHealthStatus currentHealthStatus;

    public HeartbeatTask(ApplicationEventPublisher eventPublisher, HeartbeatConfiguration configuration, CurrentHealthStatus currentHealthStatus) {
        this.eventPublisher = eventPublisher;
        this.configuration = configuration;
        this.currentHealthStatus = currentHealthStatus;
    }

    @Scheduled(fixedDelay="${micronaut.heartbeat.interval:15s}", initialDelay="${micronaut.heartbeat.initial-delay:5s}")
    public void pulsate() {
        ServiceInstance instance = this.eventReference.get();
        if (instance != null) {
            this.eventPublisher.publishEvent((Object)new HeartbeatEvent(instance, this.currentHealthStatus.current()));
        }
    }

    public void onApplicationEvent(ServiceStartedEvent event) {
        this.eventReference.set(event.getSource());
    }
}

