/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.bind;

import io.micronaut.core.bind.BeanPropertyBinder;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class MapToObjectConverter
implements TypeConverter<Map, Object> {
    private final BeanPropertyBinder beanPropertyBinder;

    public MapToObjectConverter(BeanPropertyBinder beanPropertyBinder) {
        this.beanPropertyBinder = beanPropertyBinder;
    }

    public Optional<Object> convert(Map map, Class<Object> targetType, ConversionContext context) {
        if (targetType.isInstance(map)) {
            return Optional.of(map);
        }
        return InstantiationUtils.tryInstantiate(targetType).map(object -> {
            Map theMap = map;
            LinkedHashMap bindMap = new LinkedHashMap(map.size());
            for (Map.Entry entry : theMap.entrySet()) {
                Object key = entry.getKey();
                bindMap.put(NameUtils.decapitalize((String)NameUtils.dehyphenate((String)key.toString())), entry.getValue());
            }
            return this.beanPropertyBinder.bind(object, bindMap);
        });
    }
}

