/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.convert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JsonNodeToObjectConverter
implements TypeConverter<JsonNode, Object> {
    private final ObjectMapper objectMapper;

    public JsonNodeToObjectConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Optional<Object> convert(JsonNode node, Class<Object> targetType, ConversionContext context) {
        try {
            if (CharSequence.class.isAssignableFrom(targetType) && node instanceof ObjectNode) {
                return Optional.of(node.toString());
            }
            Object result = this.objectMapper.treeToValue((TreeNode)node, targetType);
            return Optional.ofNullable(result);
        }
        catch (JsonProcessingException e) {
            context.reject((Exception)((Object)e));
            return Optional.empty();
        }
    }
}

