/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.async.processor.SingleThreadedBufferingProcessor;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonProcessor
extends SingleThreadedBufferingProcessor<byte[], JsonNode> {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonProcessor.class);
    private NonBlockingJsonParser currentNonBlockingJsonParser;
    private final ConcurrentLinkedDeque<JsonNode> nodeStack = new ConcurrentLinkedDeque();
    private final JsonFactory jsonFactory;
    private String currentFieldName;
    private boolean streamArray;

    public JacksonProcessor(JsonFactory jsonFactory, boolean streamArray) {
        try {
            this.jsonFactory = jsonFactory;
            this.currentNonBlockingJsonParser = (NonBlockingJsonParser)jsonFactory.createNonBlockingByteArrayParser();
            this.streamArray = streamArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create non-blocking JSON parser: " + e.getMessage(), e);
        }
    }

    public JacksonProcessor(JsonFactory jsonFactory) {
        this(jsonFactory, false);
    }

    public JacksonProcessor() {
        this(new JsonFactory());
    }

    public boolean needMoreInput() {
        return this.currentNonBlockingJsonParser.getNonBlockingInputFeeder().needMoreInput();
    }

    protected void doOnComplete() {
        if (this.needMoreInput()) {
            this.doOnError((Throwable)new JsonEOFException((JsonParser)this.currentNonBlockingJsonParser, JsonToken.NOT_AVAILABLE, "Unexpected end-of-input"));
        } else {
            super.doOnComplete();
        }
    }

    protected void onUpstreamMessage(byte[] message) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received upstream bytes of length: " + message.length);
            }
            ByteArrayFeeder byteFeeder = this.currentNonBlockingJsonParser.getNonBlockingInputFeeder();
            boolean consumed = false;
            boolean needMoreInput = byteFeeder.needMoreInput();
            if (!needMoreInput) {
                this.currentNonBlockingJsonParser = (NonBlockingJsonParser)this.jsonFactory.createNonBlockingByteArrayParser();
                byteFeeder = this.currentNonBlockingJsonParser.getNonBlockingInputFeeder();
            }
            while (!consumed) {
                JsonToken event;
                if (byteFeeder.needMoreInput()) {
                    byteFeeder.feedInput(message, 0, message.length);
                    consumed = true;
                }
                while ((event = this.currentNonBlockingJsonParser.nextToken()) != JsonToken.NOT_AVAILABLE) {
                    JsonNode root = this.asJsonNode(event);
                    if (root == null) continue;
                    boolean isLast = this.nodeStack.isEmpty();
                    if (isLast) {
                        byteFeeder.endOfInput();
                    }
                    if (isLast && this.streamArray && root instanceof ArrayNode) break;
                    this.currentDownstreamSubscriber().ifPresent(subscriber -> {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Materialized new JsonNode call onNext...");
                        }
                        subscriber.onNext((Object)root);
                    });
                    if (!isLast) continue;
                    break;
                }
                if (!this.needMoreInput()) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("More input required to parse JSON. Demanding more.");
                }
                this.upstreamSubscription.request(1L);
                ++this.upstreamDemand;
            }
        }
        catch (IOException e) {
            this.onError(e);
        }
    }

    private JsonNode asJsonNode(JsonToken event) throws IOException {
        block0 : switch (event) {
            case START_OBJECT: {
                this.nodeStack.push(this.node(this.nodeStack.peekFirst()));
                break;
            }
            case START_ARRAY: {
                this.nodeStack.push(this.array(this.nodeStack.peekFirst()));
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected array end literal");
                }
                JsonNode current = this.nodeStack.pop();
                if (this.nodeStack.isEmpty()) {
                    return current;
                }
                if (this.streamArray && event == JsonToken.END_OBJECT && this.nodeStack.size() == 1) {
                    JsonNode jsonNode = this.nodeStack.peekFirst();
                    if (jsonNode instanceof ArrayNode) {
                        return current;
                    }
                    return null;
                }
                return null;
            }
            case FIELD_NAME: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected field literal");
                }
                this.currentFieldName = this.currentNonBlockingJsonParser.getCurrentName();
                break;
            }
            case VALUE_NUMBER_INT: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected integer literal");
                }
                JsonNode intNode = this.nodeStack.peekFirst();
                if (intNode instanceof ObjectNode) {
                    ((ObjectNode)intNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getLongValue());
                    break;
                }
                ((ArrayNode)intNode).add(this.currentNonBlockingJsonParser.getLongValue());
                break;
            }
            case VALUE_STRING: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected string literal");
                }
                JsonNode stringNode = this.nodeStack.peekFirst();
                if (stringNode instanceof ObjectNode) {
                    ((ObjectNode)stringNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getValueAsString());
                    break;
                }
                ((ArrayNode)stringNode).add(this.currentNonBlockingJsonParser.getValueAsString());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected float literal");
                }
                JsonParser.NumberType numberType = this.currentNonBlockingJsonParser.getNumberType();
                JsonNode decimalNode = this.nodeStack.peekFirst();
                switch (numberType) {
                    case FLOAT: {
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getFloatValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getFloatValue());
                        break block0;
                    }
                    case DOUBLE: {
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getDoubleValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getDoubleValue());
                        break block0;
                    }
                    case BIG_DECIMAL: {
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getDecimalValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getDecimalValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getBigIntegerValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getBigIntegerValue());
                        break block0;
                    }
                    case LONG: {
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getLongValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getLongValue());
                        break block0;
                    }
                    case INT: {
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getIntValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getIntValue());
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported number type: " + numberType);
            }
            case VALUE_NULL: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected null literal");
                }
                JsonNode nullNode = this.nodeStack.peekFirst();
                if (nullNode instanceof ObjectNode) {
                    ((ObjectNode)nullNode).putNull(this.currentFieldName);
                    break;
                }
                ((ArrayNode)nullNode).addNull();
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected boolean literal");
                }
                JsonNode booleanNode = this.nodeStack.peekFirst();
                if (booleanNode instanceof ObjectNode) {
                    ((ObjectNode)booleanNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getBooleanValue());
                    break;
                }
                ((ArrayNode)booleanNode).add(this.currentNonBlockingJsonParser.getBooleanValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported JSON event: " + event);
            }
        }
        return null;
    }

    private JsonNode array(JsonNode node) {
        if (node instanceof ObjectNode) {
            return ((ObjectNode)node).putArray(this.currentFieldName);
        }
        if (node instanceof ArrayNode) {
            return ((ArrayNode)node).addArray();
        }
        return JsonNodeFactory.instance.arrayNode();
    }

    private JsonNode node(JsonNode node) {
        if (node instanceof ObjectNode) {
            return ((ObjectNode)node).putObject(this.currentFieldName);
        }
        if (node instanceof ArrayNode && (!this.streamArray || this.nodeStack.size() != 1)) {
            return ((ArrayNode)node).addObject();
        }
        return JsonNodeFactory.instance.objectNode();
    }
}

