/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.reactor;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Requires(classes={Flux.class})
@Context
@Internal
class ReactorInstrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(ReactorInstrumentation.class);

    ReactorInstrumentation() {
    }

    @PostConstruct
    void init(final BeanContext beanContext, ThreadFactory threadFactory) {
        block2: {
            try {
                final BeanDefinition beanDefinition = beanContext.getBeanDefinition(ExecutorService.class, Qualifiers.byName((String)"scheduled"));
                final Collection schedulerCreateListeners = beanContext.getBeansOfType(BeanCreatedEventListener.class, Qualifiers.byTypeArguments((Class[])new Class[]{ScheduledExecutorService.class}));
                Schedulers.setFactory((Schedulers.Factory)new Schedulers.Factory(){

                    public ScheduledExecutorService decorateExecutorService(String schedulerType, Supplier<? extends ScheduledExecutorService> actual) {
                        ScheduledExecutorService scheduledExecutorService = actual.get();
                        for (BeanCreatedEventListener schedulerCreateListener : schedulerCreateListeners) {
                            Object newBean = schedulerCreateListener.onCreated(new BeanCreatedEvent(beanContext, beanDefinition, BeanIdentifier.of((String)("reactor-" + schedulerType)), (Object)scheduledExecutorService));
                            if (!(newBean instanceof ScheduledExecutorService)) {
                                throw new BeanContextException("Bean creation listener [" + schedulerCreateListener + "] should return ScheduledExecutorService, but returned " + newBean);
                            }
                            scheduledExecutorService = (ScheduledExecutorService)newBean;
                        }
                        return scheduledExecutorService;
                    }

                    public Scheduler newElastic(int ttlSeconds, ThreadFactory threadFactory) {
                        return super.newElastic(ttlSeconds, threadFactory);
                    }

                    public Scheduler newParallel(int parallelism, ThreadFactory threadFactory) {
                        return super.newParallel(parallelism, threadFactory);
                    }

                    public Scheduler newSingle(ThreadFactory threadFactory) {
                        return super.newSingle(threadFactory);
                    }
                });
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Could not instrument Reactor for Tracing: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

