/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling;

import io.micronaut.scheduling.TaskScheduler;
import io.micronaut.scheduling.exceptions.TaskExecutionException;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

class ReschedulingTask<V>
implements ScheduledFuture<V>,
Runnable,
Callable<V> {
    private final Callable<V> task;
    private final TaskScheduler taskScheduler;
    private final Supplier<Duration> nextTime;
    private ScheduledFuture<?> currentFuture;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    ReschedulingTask(Callable<V> task, TaskScheduler taskScheduler, Supplier<Duration> nextTime) {
        this.task = task;
        this.taskScheduler = taskScheduler;
        this.nextTime = nextTime;
        this.currentFuture = taskScheduler.schedule(nextTime.get(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        try {
            V v = this.task.call();
            return v;
        }
        finally {
            ReschedulingTask reschedulingTask = this;
            synchronized (reschedulingTask) {
                if (!this.cancelled.get()) {
                    this.currentFuture = this.taskScheduler.schedule(this.nextTime.get(), this);
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TaskExecutionException("Error executing task: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDelay(TimeUnit unit) {
        ScheduledFuture<?> current;
        ReschedulingTask reschedulingTask = this;
        synchronized (reschedulingTask) {
            current = this.currentFuture;
        }
        return current.getDelay(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(Delayed o) {
        ScheduledFuture<?> current;
        ReschedulingTask reschedulingTask = this;
        synchronized (reschedulingTask) {
            current = this.currentFuture;
        }
        return current.compareTo(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        ScheduledFuture<?> current;
        ReschedulingTask reschedulingTask = this;
        synchronized (reschedulingTask) {
            this.cancelled.set(true);
            current = this.currentFuture;
        }
        return current.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        ReschedulingTask reschedulingTask = this;
        synchronized (reschedulingTask) {
            return this.currentFuture.isDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        ScheduledFuture<?> current;
        ReschedulingTask reschedulingTask = this;
        synchronized (reschedulingTask) {
            this.cancelled.set(true);
            current = this.currentFuture;
        }
        return current.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ScheduledFuture<?> current;
        ReschedulingTask reschedulingTask = this;
        synchronized (reschedulingTask) {
            this.cancelled.set(true);
            current = this.currentFuture;
        }
        return current.get(timeout, unit);
    }
}

