/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.AsyncCacheErrorHandler;
import io.micronaut.cache.CacheErrorHandler;
import io.micronaut.cache.CacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.annotation.CacheConfig;
import io.micronaut.cache.annotation.CacheInvalidate;
import io.micronaut.cache.annotation.CachePut;
import io.micronaut.cache.annotation.Cacheable;
import io.micronaut.cache.exceptions.CacheSystemException;
import io.micronaut.cache.interceptor.CacheKeyGenerator;
import io.micronaut.cache.interceptor.DefaultCacheKeyGenerator;
import io.micronaut.cache.interceptor.ValueSupplierException;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CacheInterceptor
implements MethodInterceptor<Object, Object> {
    public static final int POSITION = InterceptPhase.CACHE.getPosition();
    private static final String MEMBER_CACHE_NAMES = "cacheNames";
    private static final String MEMBER_ASYNC = "async";
    private static final Logger LOG = LoggerFactory.getLogger(CacheInterceptor.class);
    private static final String MEMBER_ATOMIC = "atomic";
    private static final String MEMBER_PARAMETERS = "parameters";
    private static final String MEMBER_ALL = "all";
    private static final String MEMBER_KEY_GENERATOR = "keyGenerator";
    private final CacheManager cacheManager;
    private final Map<Class<? extends CacheKeyGenerator>, CacheKeyGenerator> keyGenerators = new ConcurrentHashMap<Class<? extends CacheKeyGenerator>, CacheKeyGenerator>();
    private final BeanContext beanContext;
    private final ExecutorService ioExecutor;
    private final CacheErrorHandler errorHandler;
    private final AsyncCacheErrorHandler asyncCacheErrorHandler;

    public CacheInterceptor(CacheManager cacheManager, CacheErrorHandler errorHandler, AsyncCacheErrorHandler asyncCacheErrorHandler, @Named(value="io") ExecutorService ioExecutor, BeanContext beanContext) {
        this.cacheManager = cacheManager;
        this.errorHandler = errorHandler;
        this.asyncCacheErrorHandler = asyncCacheErrorHandler;
        this.beanContext = beanContext;
        this.ioExecutor = ioExecutor;
    }

    public int getOrder() {
        return POSITION;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasStereotype(CacheConfig.class)) {
            ReturnType returnTypeObject = context.getReturnType();
            Class returnType = returnTypeObject.getType();
            if (CompletableFuture.class.isAssignableFrom(returnType)) {
                return this.interceptCompletableFuture(context, returnTypeObject, returnType);
            }
            if (Publishers.isConvertibleToPublisher((Class)returnType)) {
                return this.interceptPublisher(context, returnTypeObject, returnType);
            }
            return this.interceptSync(context, returnTypeObject, returnType);
        }
        return context.proceed();
    }

    protected Object interceptSync(MethodInvocationContext context, ReturnType returnTypeObject, Class returnType) {
        List<AnnotationValue<CacheInvalidate>> cacheInvalidates;
        ValueWrapper wrapper = new ValueWrapper();
        CacheOperation cacheOperation = new CacheOperation(context, returnType);
        AnnotationValue<Cacheable> cacheConfig = cacheOperation.cacheable;
        if (cacheConfig != null) {
            CacheKeyGenerator defaultKeyGenerator = cacheOperation.defaultKeyGenerator;
            CacheKeyGenerator keyGenerator = this.resolveKeyGenerator(defaultKeyGenerator, cacheConfig);
            Object[] objectArray = this.resolveParams(context, (String[])cacheConfig.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY));
            Object key = keyGenerator.generateKey((AnnotationMetadata)context, objectArray);
            Argument returnArgument = returnTypeObject.asArgument();
            if (((Boolean)cacheConfig.getRequiredValue(MEMBER_ATOMIC, Boolean.class)).booleanValue()) {
                SyncCache syncCache = this.cacheManager.getCache(cacheOperation.cacheableCacheName);
                try {
                    wrapper.value = syncCache.get(key, returnArgument, () -> {
                        try {
                            this.doProceed(context, wrapper);
                            return wrapper.value;
                        }
                        catch (RuntimeException e) {
                            throw new ValueSupplierException(key, e);
                        }
                    });
                }
                catch (ValueSupplierException e) {
                    throw e.getCause();
                }
                catch (RuntimeException e) {
                    this.errorHandler.handleLoadError(syncCache, key, e);
                    throw e;
                }
            } else {
                String[] cacheNames = this.resolveCacheNames(cacheOperation.defaultConfig, cacheConfig);
                boolean cacheHit = false;
                for (String cacheName : cacheNames) {
                    SyncCache syncCache = this.cacheManager.getCache(cacheName);
                    try {
                        Optional optional = syncCache.get(key, returnArgument);
                        if (!optional.isPresent()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Value found in cache [" + cacheName + "] for invocation: " + context);
                        }
                        cacheHit = true;
                        wrapper.value = optional.get();
                        break;
                    }
                    catch (RuntimeException e) {
                        if (!this.errorHandler.handleLoadError(syncCache, key, e)) continue;
                        throw e;
                    }
                }
                if (!cacheHit) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value not found in cache for invocation: " + context);
                    }
                    this.doProceed(context, wrapper);
                    this.syncPut(cacheNames, key, wrapper.value);
                }
            }
        } else {
            if (!cacheOperation.hasWriteOperations()) {
                return context.proceed();
            }
            this.doProceed(context, wrapper);
        }
        List<AnnotationValue<CachePut>> cachePuts = cacheOperation.putOperations;
        if (cachePuts != null) {
            for (AnnotationValue annotationValue : cachePuts) {
                boolean async = (Boolean)annotationValue.get((CharSequence)MEMBER_ASYNC, Boolean.class, (Object)false);
                if (async) {
                    this.ioExecutor.submit(() -> this.processCachePut(context, wrapper, (AnnotationValue<CachePut>)cachePut, cacheOperation));
                    continue;
                }
                this.processCachePut(context, wrapper, (AnnotationValue<CachePut>)annotationValue, cacheOperation);
            }
        }
        if ((cacheInvalidates = cacheOperation.invalidateOperations) != null) {
            for (AnnotationValue<CacheInvalidate> cacheInvalidate : cacheInvalidates) {
                boolean async = (Boolean)cacheInvalidate.get((CharSequence)MEMBER_ASYNC, Boolean.class, (Object)false);
                if (async) {
                    this.ioExecutor.submit(() -> {
                        try {
                            this.processCacheEvict(context, cacheInvalidate, cacheOperation, async);
                        }
                        catch (Exception e) {
                            throw new CacheSystemException("Cache invalidate operation failed: " + e.getMessage(), e);
                        }
                    });
                    continue;
                }
                this.processCacheEvict(context, cacheInvalidate, cacheOperation, async);
            }
        }
        return wrapper.optional ? Optional.ofNullable(wrapper.value) : wrapper.value;
    }

    protected Object interceptCompletableFuture(MethodInvocationContext<Object, Object> context, ReturnType<?> returnTypeObject, Class returnType) {
        CompletableFuture<Object> returnFuture;
        CacheOperation cacheOperation = new CacheOperation(context, returnType);
        AnnotationValue<Cacheable> cacheable = cacheOperation.cacheable;
        if (cacheable != null) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheOperation.cacheableCacheName).async();
            CacheKeyGenerator keyGenerator = this.resolveKeyGenerator(cacheOperation.defaultKeyGenerator, cacheable);
            Object[] params = this.resolveParams(context, (String[])cacheable.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY));
            Object key = keyGenerator.generateKey((AnnotationMetadata)context, params);
            CompletableFuture thisFuture = new CompletableFuture();
            Argument firstTypeVariable = returnTypeObject.getFirstTypeVariable().orElse(Argument.of(Object.class));
            asyncCache.get(key, firstTypeVariable).whenComplete((o, throwable) -> {
                if (throwable == null && o.isPresent()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value found in cache [" + asyncCache.getName() + "] for invocation: " + context);
                    }
                    thisFuture.complete(o.get());
                } else {
                    try {
                        if (throwable != null && this.errorHandler.handleLoadError(asyncCache, key, this.asRuntimeException((Throwable)throwable))) {
                            thisFuture.completeExceptionally((Throwable)throwable);
                            return;
                        }
                        CompletableFuture completableFuture = (CompletableFuture)context.proceed();
                        if (completableFuture == null) {
                            thisFuture.complete(null);
                        } else {
                            completableFuture.whenComplete((o1, t2) -> {
                                if (t2 != null) {
                                    thisFuture.completeExceptionally((Throwable)t2);
                                } else {
                                    asyncCache.put(key, o1).whenComplete((aBoolean, throwable1) -> {
                                        if (throwable1 == null) {
                                            thisFuture.complete(o1);
                                        } else {
                                            thisFuture.completeExceptionally((Throwable)throwable1);
                                        }
                                    });
                                }
                            });
                        }
                    }
                    catch (RuntimeException e) {
                        thisFuture.completeExceptionally(e);
                    }
                }
            });
            returnFuture = thisFuture;
        } else {
            returnFuture = (CompletableFuture<Object>)context.proceed();
        }
        if (cacheOperation.hasWriteOperations()) {
            returnFuture = this.processFuturePutOperations(context, cacheOperation, returnFuture);
        }
        return returnFuture;
    }

    protected List<AnnotationValue<CachePut>> putOperations(MethodInvocationContext context) {
        return context.getAnnotationValuesByType(CachePut.class);
    }

    protected List<AnnotationValue<CacheInvalidate>> invalidateOperations(MethodInvocationContext context) {
        return context.getAnnotationValuesByType(CacheInvalidate.class);
    }

    private Object interceptPublisher(MethodInvocationContext<Object, Object> context, ReturnType returnTypeObject, Class returnType) {
        if (!Publishers.isSingle((Class)returnType) && !context.isAnnotationPresent(SingleResult.class)) {
            throw new CacheSystemException("Only Reactive types that emit a single result can currently be cached. Use either Single, Maybe or Mono for operations that cache.");
        }
        CacheOperation cacheOperation = new CacheOperation(context, returnType);
        AnnotationValue<Cacheable> cacheable = cacheOperation.cacheable;
        if (cacheable != null) {
            Publisher<Object> publisher = this.buildCacheablePublisher(context, returnTypeObject, cacheOperation, cacheable);
            return Publishers.convertPublisher(publisher, (Class)returnType);
        }
        List<AnnotationValue<CachePut>> putOperations = cacheOperation.putOperations;
        if (CollectionUtils.isNotEmpty(putOperations)) {
            Publisher<Object> publisher = this.buildCachePutPublisher(context, cacheOperation, putOperations);
            return Publishers.convertPublisher(publisher, (Class)returnType);
        }
        List<AnnotationValue<CacheInvalidate>> invalidateOperations = cacheOperation.invalidateOperations;
        if (CollectionUtils.isNotEmpty(invalidateOperations)) {
            Publisher<Object> publisher = this.buildCacheInvalidatePublisher(context, cacheOperation, invalidateOperations);
            return Publishers.convertPublisher(publisher, (Class)returnType);
        }
        return context.proceed();
    }

    private Publisher<Object> buildCacheInvalidatePublisher(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, List<AnnotationValue<CacheInvalidate>> invalidateOperations) {
        Flowable originalFlowable = (Flowable)Publishers.convertPublisher((Object)context.proceed(), Flowable.class);
        return originalFlowable.flatMap(o -> {
            ArrayList<Flowable> cacheInvalidates = new ArrayList<Flowable>();
            for (AnnotationValue invalidateOperation : invalidateOperations) {
                Object[] cacheNames = cacheOperation.getCacheInvalidateNames((AnnotationValue<CacheInvalidate>)invalidateOperation);
                if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                boolean invalidateAll = (Boolean)invalidateOperation.getRequiredValue(MEMBER_ALL, Boolean.class);
                boolean isAsync = (Boolean)invalidateOperation.get((CharSequence)MEMBER_ASYNC, Boolean.class, (Object)false);
                if (isAsync) {
                    if (invalidateAll) {
                        for (Object cacheName : cacheNames) {
                            AsyncCache asyncCache = this.cacheManager.getCache((String)cacheName).async();
                            asyncCache.invalidateAll().whenCompleteAsync((aBoolean, throwable) -> {
                                if (throwable != null) {
                                    this.asyncCacheErrorHandler.handleInvalidateError(asyncCache, this.asRuntimeException((Throwable)throwable));
                                }
                            }, (Executor)this.ioExecutor);
                        }
                        continue;
                    }
                    CacheKeyGenerator keyGenerator = cacheOperation.getCacheInvalidateKeyGenerator((AnnotationValue<CacheInvalidate>)invalidateOperation);
                    String[] parameterNames = (String[])invalidateOperation.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY);
                    Object[] parameterValues = this.resolveParams(context, parameterNames);
                    Object key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
                    for (Object cacheName : cacheNames) {
                        AsyncCache asyncCache = this.cacheManager.getCache((String)cacheName).async();
                        asyncCache.invalidate(key).whenCompleteAsync((aBoolean, throwable) -> {
                            if (throwable != null) {
                                this.asyncCacheErrorHandler.handleInvalidateError(asyncCache, this.asRuntimeException((Throwable)throwable));
                            }
                        }, (Executor)this.ioExecutor);
                    }
                    continue;
                }
                Flowable cacheInvalidateFlowable = Flowable.create(arg_0 -> this.lambda$null$10(invalidateAll, (String[])cacheNames, o, cacheOperation, invalidateOperation, context, arg_0), (BackpressureStrategy)BackpressureStrategy.ERROR);
                cacheInvalidates.add(cacheInvalidateFlowable);
            }
            if (!cacheInvalidates.isEmpty()) {
                return Flowable.merge(cacheInvalidates).lastOrError().toFlowable();
            }
            return Flowable.just((Object)o);
        });
    }

    private Publisher<Object> buildCachePutPublisher(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, List<AnnotationValue<CachePut>> putOperations) {
        Flowable originalFlowable = (Flowable)Publishers.convertPublisher((Object)context.proceed(), Flowable.class);
        return originalFlowable.flatMap(o -> {
            ArrayList<Flowable> cachePuts = new ArrayList<Flowable>();
            for (AnnotationValue putOperation : putOperations) {
                Object[] cacheNames = cacheOperation.getCachePutNames((AnnotationValue<CachePut>)putOperation);
                if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                boolean isAsync = (Boolean)putOperation.get((CharSequence)MEMBER_ASYNC, Boolean.class, (Object)false);
                if (isAsync) {
                    this.putResultAsync(context, cacheOperation, (AnnotationValue<CachePut>)putOperation, (String[])cacheNames, o);
                    continue;
                }
                Flowable cachePutFlowable = Flowable.create(arg_0 -> this.lambda$null$13(cacheOperation, putOperation, context, (String[])cacheNames, o, arg_0), (BackpressureStrategy)BackpressureStrategy.ERROR);
                cachePuts.add(cachePutFlowable);
            }
            if (!cachePuts.isEmpty()) {
                return Flowable.merge(cachePuts).lastOrError().toFlowable();
            }
            return Flowable.just((Object)o);
        });
    }

    private Publisher<Object> buildCacheablePublisher(MethodInvocationContext<Object, Object> context, ReturnType returnTypeObject, CacheOperation cacheOperation, AnnotationValue<Cacheable> cacheable) {
        AsyncCache asyncCache = this.cacheManager.getCache(cacheOperation.cacheableCacheName).async();
        CacheKeyGenerator keyGenerator = this.resolveKeyGenerator(cacheOperation.defaultKeyGenerator, cacheable);
        Object[] params = this.resolveParams(context, (String[])cacheable.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY));
        Object key = keyGenerator.generateKey((AnnotationMetadata)context, params);
        Flowable originalFlowable = (Flowable)Publishers.convertPublisher((Object)context.proceed(), Flowable.class);
        return Flowable.create(emitter -> {
            Argument firstTypeVariable = returnTypeObject.getFirstTypeVariable().orElse(Argument.of(Object.class));
            asyncCache.get(key, firstTypeVariable).whenComplete((o, throwable) -> {
                if (throwable == null && o.isPresent()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value found in cache [" + asyncCache.getName() + "] for invocation: " + context);
                    }
                    emitter.onNext(o.get());
                    emitter.onComplete();
                } else if (throwable != null) {
                    if (this.errorHandler.handleLoadError(asyncCache, key, this.asRuntimeException((Throwable)throwable))) {
                        emitter.onError(throwable);
                    } else {
                        emitter.onComplete();
                    }
                } else {
                    emitter.onComplete();
                }
            });
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).switchIfEmpty((Publisher)originalFlowable.flatMap(o -> Flowable.create(emitter -> asyncCache.put(key, o).whenComplete((aBoolean, throwable1) -> {
            if (throwable1 == null) {
                emitter.onNext(o);
                emitter.onComplete();
            } else if (this.errorHandler.handleLoadError(asyncCache, key, this.asRuntimeException((Throwable)throwable1))) {
                emitter.onError(throwable1);
            } else {
                emitter.onNext(o);
                emitter.onComplete();
            }
        }), (BackpressureStrategy)BackpressureStrategy.ERROR)));
    }

    private CompletableFuture<Object> processFuturePutOperations(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, CompletableFuture<Object> returnFuture) {
        List<AnnotationValue<CachePut>> putOperations = cacheOperation.putOperations;
        if (putOperations != null) {
            for (AnnotationValue<CachePut> putOperation : putOperations) {
                Object[] cacheNames = cacheOperation.getCachePutNames(putOperation);
                if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                boolean isAsync = (Boolean)putOperation.get((CharSequence)MEMBER_ASYNC, Boolean.class, (Object)false);
                if (!isAsync) {
                    CompletableFuture newFuture = new CompletableFuture();
                    returnFuture.whenComplete((arg_0, arg_1) -> this.lambda$processFuturePutOperations$21(cacheOperation, putOperation, context, (String[])cacheNames, newFuture, arg_0, arg_1));
                    returnFuture = newFuture;
                    continue;
                }
                returnFuture.whenCompleteAsync((arg_0, arg_1) -> this.lambda$processFuturePutOperations$22(context, cacheOperation, putOperation, (String[])cacheNames, arg_0, arg_1), (Executor)this.ioExecutor);
            }
        }
        return returnFuture;
    }

    private void putResultAsync(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, AnnotationValue<CachePut> putOperation, String[] cacheNames, Object result) {
        block2: {
            try {
                CacheKeyGenerator keyGenerator = cacheOperation.getCachePutKeyGenerator(putOperation);
                Object[] parameterValues = this.resolveParams(context, (String[])putOperation.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY));
                Object key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
                CompletableFuture<Void> putOperationFuture = this.buildPutFutures(cacheNames, result, key);
                putOperationFuture.whenComplete((aVoid, error) -> {
                    if (error != null) {
                        SyncCache cache = this.cacheManager.getCache(cacheNames[0]);
                        this.asyncCacheErrorHandler.handlePutError(cache, key, result, this.asRuntimeException((Throwable)error));
                    }
                });
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Cache put operation failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected CacheKeyGenerator resolveKeyGenerator(Class<? extends CacheKeyGenerator> type) {
        if (type == null) {
            type = DefaultCacheKeyGenerator.class;
        }
        return this.keyGenerators.computeIfAbsent(type, aClass -> {
            if (this.beanContext.containsBean(aClass)) {
                return (CacheKeyGenerator)this.beanContext.getBean(aClass);
            }
            return (CacheKeyGenerator)InstantiationUtils.instantiate((Class)aClass);
        });
    }

    private CompletableFuture<Void> buildPutFutures(String[] cacheNames, Object result, Object key) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (String cacheName : cacheNames) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheName).async();
            futures.add(asyncCache.put(key, result));
        }
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futureArray);
    }

    private CompletableFuture<Void> buildInvalidateFutures(String[] cacheNames, Object key) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (String cacheName : cacheNames) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheName).async();
            futures.add(asyncCache.invalidate(key));
        }
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futureArray);
    }

    private CompletableFuture<Void> buildInvalidateAllFutures(String[] cacheNames) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (String cacheName : cacheNames) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheName).async();
            futures.add(asyncCache.invalidateAll());
        }
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futureArray);
    }

    private CacheKeyGenerator resolveKeyGenerator(CacheKeyGenerator defaultKeyGenerator, AnnotationValue<Cacheable> cacheConfig) {
        CacheKeyGenerator keyGenerator = defaultKeyGenerator;
        CacheKeyGenerator altKeyGenInstance = cacheConfig.get((CharSequence)MEMBER_KEY_GENERATOR, CacheKeyGenerator.class).orElse(null);
        if (altKeyGenInstance != null) {
            return altKeyGenInstance;
        }
        Class alternateKeyGen = cacheConfig.get((CharSequence)MEMBER_KEY_GENERATOR, Class.class).orElse(null);
        if (alternateKeyGen != null && keyGenerator.getClass() != alternateKeyGen) {
            keyGenerator = this.resolveKeyGenerator(alternateKeyGen);
        }
        if (keyGenerator == null) {
            return new DefaultCacheKeyGenerator();
        }
        return keyGenerator;
    }

    private String[] resolveCacheNames(AnnotationValue<CacheConfig> defaultConfig, AnnotationValue<Cacheable> cacheConfig) {
        Object[] cacheNames = cacheConfig.get((CharSequence)MEMBER_CACHE_NAMES, String[].class).orElse(null);
        if (ArrayUtils.isEmpty((Object[])cacheNames)) {
            cacheNames = defaultConfig.get((CharSequence)MEMBER_CACHE_NAMES, String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY);
        }
        return cacheNames;
    }

    private void doProceed(MethodInvocationContext context, ValueWrapper wrapper) {
        Object result = context.proceed();
        if (result instanceof Optional) {
            Optional optional = (Optional)result;
            wrapper.optional = true;
            if (optional.isPresent()) {
                wrapper.value = optional.get();
            }
        } else {
            wrapper.value = result;
        }
    }

    private void processCachePut(MethodInvocationContext<?, ?> context, ValueWrapper wrapper, AnnotationValue<CachePut> cacheConfig, CacheOperation cacheOperation) {
        String[] cacheNames = cacheOperation.getCachePutNames(cacheConfig);
        CacheKeyGenerator keyGenerator = cacheOperation.getCachePutKeyGenerator(cacheConfig);
        String[] parameterNames = (String[])cacheConfig.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY);
        Object[] parameterValues = this.resolveParams(context, parameterNames);
        boolean isAsync = (Boolean)cacheConfig.get((CharSequence)MEMBER_ASYNC, Boolean.class, (Object)false);
        this.processCachePut(context, wrapper, cacheNames, keyGenerator, parameterValues, isAsync);
    }

    private void processCachePut(MethodInvocationContext<?, ?> context, ValueWrapper wrapper, String[] cacheNames, CacheKeyGenerator keyGenerator, Object[] parameterValues, boolean isAsync) {
        if (!ArrayUtils.isEmpty((Object[])cacheNames)) {
            Object v = wrapper.value;
            if (isAsync) {
                this.ioExecutor.submit(() -> {
                    try {
                        Object key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
                        for (String cacheName : cacheNames) {
                            SyncCache cache = this.cacheManager.getCache(cacheName);
                            AsyncCache asyncCache = cache.async();
                            CompletableFuture<Boolean> putFuture = asyncCache.put(key, v);
                            putFuture.whenCompleteAsync((aBoolean, throwable) -> {
                                if (throwable != null) {
                                    this.asyncCacheErrorHandler.handlePutError(cache, key, v, this.asRuntimeException((Throwable)throwable));
                                }
                            }, (Executor)this.ioExecutor);
                        }
                    }
                    catch (Exception e) {
                        throw new CacheSystemException("Cache put operation failed: " + e.getMessage(), e);
                    }
                });
            } else {
                Object key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
                this.syncPut(cacheNames, key, v);
            }
        }
    }

    private void syncPut(String[] cacheNames, Object key, Object value) {
        for (String cacheName : cacheNames) {
            SyncCache syncCache = this.cacheManager.getCache(cacheName);
            try {
                syncCache.put(key, value);
            }
            catch (RuntimeException e) {
                if (!this.errorHandler.handlePutError(syncCache, key, value, e)) continue;
                throw e;
            }
        }
    }

    private void processCacheEvict(MethodInvocationContext context, AnnotationValue<CacheInvalidate> cacheConfig, CacheOperation cacheOperation, boolean async) {
        Object[] cacheNames = cacheOperation.getCacheInvalidateNames(cacheConfig);
        CacheKeyGenerator keyGenerator = cacheOperation.getCacheInvalidateKeyGenerator(cacheConfig);
        boolean invalidateAll = (Boolean)cacheConfig.getRequiredValue(MEMBER_ALL, Boolean.class);
        Object key = null;
        String[] parameterNames = (String[])cacheConfig.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY);
        Object[] parameterValues = this.resolveParams(context, parameterNames);
        if (!invalidateAll) {
            key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
        }
        if (!ArrayUtils.isEmpty((Object[])cacheNames)) {
            for (Object cacheName : cacheNames) {
                SyncCache syncCache = this.cacheManager.getCache((String)cacheName);
                if (async) {
                    AsyncCache asyncCache = syncCache.async();
                    if (invalidateAll) {
                        CompletableFuture<Boolean> future = asyncCache.invalidateAll();
                        future.whenCompleteAsync((aBoolean, throwable) -> {
                            if (throwable != null) {
                                this.asyncCacheErrorHandler.handleInvalidateError(syncCache, this.asRuntimeException((Throwable)throwable));
                            }
                        }, (Executor)this.ioExecutor);
                        continue;
                    }
                    Object finalKey = key;
                    CompletableFuture<Boolean> future = asyncCache.invalidate(key);
                    future.whenCompleteAsync((aBoolean, throwable) -> {
                        if (throwable != null) {
                            this.asyncCacheErrorHandler.handleInvalidateError(syncCache, finalKey, this.asRuntimeException((Throwable)throwable));
                        }
                    }, (Executor)this.ioExecutor);
                    continue;
                }
                if (invalidateAll) {
                    try {
                        syncCache.invalidateAll();
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (!this.errorHandler.handleInvalidateError(syncCache, e)) continue;
                        throw e;
                    }
                }
                try {
                    syncCache.invalidate(key);
                }
                catch (RuntimeException e) {
                    if (!this.errorHandler.handleInvalidateError(syncCache, key, e)) continue;
                    throw e;
                }
            }
        }
    }

    private RuntimeException asRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    private Object[] resolveParams(MethodInvocationContext<?, ?> context, String[] parameterNames) {
        Object[] parameterValues;
        if (ArrayUtils.isEmpty((Object[])parameterNames)) {
            parameterValues = context.getParameterValues();
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            Map parameters = context.getParameters();
            for (String name : parameterNames) {
                list.add(((MutableArgumentValue)parameters.get(name)).getValue());
            }
            parameterValues = list.toArray();
        }
        return parameterValues;
    }

    private /* synthetic */ void lambda$processFuturePutOperations$22(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue putOperation, String[] cacheNames, Object result, Throwable throwable) {
        if (throwable == null) {
            this.putResultAsync((MethodInvocationContext<Object, Object>)context, cacheOperation, (AnnotationValue<CachePut>)putOperation, cacheNames, result);
        }
    }

    private /* synthetic */ void lambda$processFuturePutOperations$21(CacheOperation cacheOperation, AnnotationValue putOperation, MethodInvocationContext context, String[] cacheNames, CompletableFuture newFuture, Object result, Throwable throwable) {
        if (throwable == null) {
            try {
                CacheKeyGenerator keyGenerator = cacheOperation.getCachePutKeyGenerator((AnnotationValue<CachePut>)putOperation);
                Object[] parameterValues = this.resolveParams(context, (String[])putOperation.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY));
                Object key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
                CompletableFuture<Void> putOperationFuture = this.buildPutFutures(cacheNames, result, key);
                putOperationFuture.whenComplete((aVoid, error) -> {
                    if (error != null) {
                        SyncCache cache = this.cacheManager.getCache(cacheNames[0]);
                        if (this.errorHandler.handlePutError(cache, key, result, this.asRuntimeException((Throwable)error))) {
                            newFuture.completeExceptionally((Throwable)error);
                        } else {
                            newFuture.complete(result);
                        }
                    } else {
                        newFuture.complete(result);
                    }
                });
            }
            catch (Exception e) {
                newFuture.completeExceptionally(e);
            }
        } else {
            newFuture.completeExceptionally(throwable);
        }
    }

    private /* synthetic */ void lambda$null$13(CacheOperation cacheOperation, AnnotationValue putOperation, MethodInvocationContext context, String[] cacheNames, Object o, FlowableEmitter emitter) throws Exception {
        CacheKeyGenerator keyGenerator = cacheOperation.getCachePutKeyGenerator((AnnotationValue<CachePut>)putOperation);
        Object[] parameterValues = this.resolveParams(context, (String[])putOperation.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY));
        Object key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
        CompletableFuture<Void> putOperationFuture = this.buildPutFutures(cacheNames, o, key);
        putOperationFuture.whenComplete((aVoid, throwable) -> {
            if (throwable == null) {
                emitter.onNext(o);
                emitter.onComplete();
            } else {
                SyncCache cache = this.cacheManager.getCache(cacheNames[0]);
                if (this.errorHandler.handlePutError(cache, key, o, this.asRuntimeException((Throwable)throwable))) {
                    emitter.onError(throwable);
                } else {
                    emitter.onNext(o);
                    emitter.onComplete();
                }
            }
        });
    }

    private /* synthetic */ void lambda$null$10(boolean invalidateAll, String[] cacheNames, Object o, CacheOperation cacheOperation, AnnotationValue invalidateOperation, MethodInvocationContext context, FlowableEmitter emitter) throws Exception {
        if (invalidateAll) {
            CompletableFuture<Void> allFutures = this.buildInvalidateAllFutures(cacheNames);
            allFutures.whenCompleteAsync((aBoolean, throwable) -> {
                if (throwable != null) {
                    SyncCache cache = this.cacheManager.getCache(cacheNames[0]);
                    if (this.asyncCacheErrorHandler.handleInvalidateError(cache, this.asRuntimeException((Throwable)throwable))) {
                        emitter.onError(throwable);
                        return;
                    }
                    emitter.onNext((Object)true);
                    emitter.onComplete();
                } else {
                    emitter.onNext(o);
                    emitter.onComplete();
                }
            }, (Executor)this.ioExecutor);
        } else {
            CacheKeyGenerator keyGenerator = cacheOperation.getCacheInvalidateKeyGenerator((AnnotationValue<CacheInvalidate>)invalidateOperation);
            String[] parameterNames = (String[])invalidateOperation.get((CharSequence)MEMBER_PARAMETERS, String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY);
            Object[] parameterValues = this.resolveParams(context, parameterNames);
            Object key = keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
            CompletableFuture<Void> allFutures = this.buildInvalidateFutures(cacheNames, key);
            allFutures.whenCompleteAsync((aBoolean, throwable) -> {
                SyncCache cache;
                if (throwable != null && this.asyncCacheErrorHandler.handleInvalidateError(cache = this.cacheManager.getCache(cacheNames[0]), key, this.asRuntimeException((Throwable)throwable))) {
                    emitter.onError(throwable);
                    return;
                }
                emitter.onNext(o);
                emitter.onComplete();
            }, (Executor)this.ioExecutor);
        }
    }

    private class ValueWrapper {
        Object value;
        boolean optional;

        private ValueWrapper() {
        }
    }

    private class CacheOperation {
        final Class returnType;
        final MethodInvocationContext<?, ?> context;
        final CacheKeyGenerator defaultKeyGenerator;
        final AnnotationValue<CacheConfig> defaultConfig;
        String cacheableCacheName;
        AnnotationValue<Cacheable> cacheable;
        List<AnnotationValue<CachePut>> putOperations;
        List<AnnotationValue<CacheInvalidate>> invalidateOperations;

        CacheOperation(MethodInvocationContext<?, ?> context, Class returnType) {
            AnnotationValue cacheable;
            Object[] names;
            this.context = context;
            this.returnType = returnType;
            this.defaultConfig = context.getAnnotation(CacheConfig.class);
            this.defaultKeyGenerator = CacheInterceptor.this.resolveKeyGenerator(this.defaultConfig.get((CharSequence)CacheInterceptor.MEMBER_KEY_GENERATOR, Class.class).orElse(null));
            boolean isVoid = this.isVoid();
            this.putOperations = isVoid ? null : CacheInterceptor.this.putOperations(context);
            this.invalidateOperations = CacheInterceptor.this.invalidateOperations(context);
            if (!isVoid && context.hasStereotype(Cacheable.class) && ArrayUtils.isNotEmpty((Object[])(names = CacheInterceptor.this.resolveCacheNames((AnnotationValue<CacheConfig>)this.defaultConfig, (AnnotationValue<Cacheable>)(cacheable = context.getAnnotation(Cacheable.class)))))) {
                this.cacheableCacheName = names[0];
                this.cacheable = cacheable;
            }
        }

        boolean hasWriteOperations() {
            return this.putOperations != null || this.invalidateOperations != null;
        }

        boolean isVoid() {
            return Void.TYPE == this.returnType;
        }

        String[] getCachePutNames(AnnotationValue<CachePut> cacheConfig) {
            return this.getCacheNames(cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_CACHE_NAMES, String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY));
        }

        String[] getCacheInvalidateNames(AnnotationValue<CacheInvalidate> cacheConfig) {
            return this.getCacheNames(cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_CACHE_NAMES, String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY));
        }

        CacheKeyGenerator getCacheInvalidateKeyGenerator(AnnotationValue<CacheInvalidate> cacheConfig) {
            return cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_KEY_GENERATOR, CacheKeyGenerator.class).orElseGet(() -> this.getKeyGenerator(cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_KEY_GENERATOR, Class.class).orElse(null)));
        }

        CacheKeyGenerator getCachePutKeyGenerator(AnnotationValue<CachePut> cacheConfig) {
            return cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_KEY_GENERATOR, CacheKeyGenerator.class).orElseGet(() -> this.getKeyGenerator(cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_KEY_GENERATOR, Class.class).orElse(null)));
        }

        private String[] getCacheNames(String[] cacheNames) {
            if (ArrayUtils.isEmpty((Object[])cacheNames)) {
                return this.defaultConfig.get((CharSequence)CacheInterceptor.MEMBER_CACHE_NAMES, String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY);
            }
            return cacheNames;
        }

        private CacheKeyGenerator getKeyGenerator(Class<? extends CacheKeyGenerator> alternateKeyGen) {
            CacheKeyGenerator keyGenerator = this.defaultKeyGenerator;
            if (alternateKeyGen != null && this.defaultKeyGenerator.getClass() != alternateKeyGen) {
                keyGenerator = CacheInterceptor.this.resolveKeyGenerator(alternateKeyGen);
            }
            return keyGenerator;
        }
    }
}

