/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.jcache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.SyncCache;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.cache.Cache;

class JCacheSyncCache
implements SyncCache<Cache> {
    private final Cache nativeCache;
    private final ConversionService<?> conversionService;
    private final AsyncCache<Cache> asyncCache;

    JCacheSyncCache(@Nonnull Cache<?, ?> nativeCache, ConversionService<?> conversionService, final ExecutorService ioExecutor) {
        ArgumentUtils.requireNonNull((String)"nativeCache", nativeCache);
        this.nativeCache = nativeCache;
        this.conversionService = conversionService;
        this.asyncCache = new AsyncCache<Cache>(){

            @Override
            public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
                return CompletableFuture.supplyAsync(() -> JCacheSyncCache.this.get(key, requiredType), ioExecutor);
            }

            @Override
            public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
                return CompletableFuture.supplyAsync(() -> JCacheSyncCache.this.get(key, requiredType, supplier), ioExecutor);
            }

            @Override
            public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
                return CompletableFuture.supplyAsync(() -> JCacheSyncCache.this.putIfAbsent(key, value), ioExecutor);
            }

            @Override
            public CompletableFuture<Boolean> put(Object key, Object value) {
                return CompletableFuture.supplyAsync(() -> {
                    JCacheSyncCache.this.nativeCache.put(key, value);
                    return true;
                }, ioExecutor);
            }

            @Override
            public CompletableFuture<Boolean> invalidate(Object key) {
                return CompletableFuture.supplyAsync(() -> {
                    JCacheSyncCache.this.invalidate(key);
                    return true;
                }, ioExecutor);
            }

            @Override
            public CompletableFuture<Boolean> invalidateAll() {
                return CompletableFuture.supplyAsync(() -> {
                    JCacheSyncCache.this.invalidateAll();
                    return true;
                }, ioExecutor);
            }

            @Override
            public String getName() {
                return JCacheSyncCache.this.getName();
            }

            @Override
            public Cache getNativeCache() {
                return JCacheSyncCache.this.nativeCache;
            }
        };
    }

    @Override
    public <T> Optional<T> get(Object key, Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        Object v = this.nativeCache.get(key);
        if (v != null) {
            return this.conversionService.convert(v, requiredType);
        }
        return Optional.empty();
    }

    @Override
    public <T> T get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        return this.get(key, requiredType).orElseGet(supplier);
    }

    @Override
    public <T> Optional<T> putIfAbsent(Object key, T value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        Object v = this.nativeCache.getAndReplace(key, value);
        Class<?> aClass = value.getClass();
        return this.conversionService.convert(v, aClass);
    }

    @Override
    public void put(Object key, Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        if (value != null) {
            this.nativeCache.put(key, value);
        }
    }

    @Override
    public void invalidate(Object key) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        this.nativeCache.remove(key);
    }

    @Override
    public void invalidateAll() {
        this.nativeCache.clear();
    }

    @Override
    public String getName() {
        return this.nativeCache.getName();
    }

    @Override
    public Cache<?, ?> getNativeCache() {
        return this.nativeCache;
    }

    @Override
    public AsyncCache<Cache> async() {
        return this.asyncCache;
    }
}

