/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery;

import io.micronaut.core.naming.Described;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CompositeDiscoveryClient
implements DiscoveryClient {
    private final DiscoveryClient[] discoveryClients;

    protected CompositeDiscoveryClient(DiscoveryClient[] discoveryClients) {
        this.discoveryClients = discoveryClients;
    }

    public String getDescription() {
        return this.toString();
    }

    public DiscoveryClient[] getDiscoveryClients() {
        return this.discoveryClients;
    }

    public Flowable<List<ServiceInstance>> getInstances(String serviceId) {
        serviceId = NameUtils.hyphenate((String)serviceId);
        if (ArrayUtils.isEmpty((Object[])this.discoveryClients)) {
            return Flowable.just(Collections.emptyList());
        }
        String finalServiceId = serviceId;
        Stream<Flowable> flowableStream = Arrays.stream(this.discoveryClients).map(client -> Flowable.fromPublisher(client.getInstances(finalServiceId)));
        Maybe reduced = Flowable.merge((Iterable)flowableStream.collect(Collectors.toList())).reduce((instances, otherInstances) -> {
            instances.addAll(otherInstances);
            return instances;
        });
        return reduced.toFlowable();
    }

    public Flowable<List<String>> getServiceIds() {
        if (ArrayUtils.isEmpty((Object[])this.discoveryClients)) {
            return Flowable.just(Collections.emptyList());
        }
        Stream<Flowable> flowableStream = Arrays.stream(this.discoveryClients).map(client -> Flowable.fromPublisher(client.getServiceIds()));
        Maybe reduced = Flowable.merge((Iterable)flowableStream.collect(Collectors.toList())).reduce((strings, strings2) -> {
            strings.addAll(strings2);
            return strings;
        });
        return reduced.toFlowable();
    }

    @Override
    public void close() throws IOException {
        for (DiscoveryClient discoveryClient : this.discoveryClients) {
            discoveryClient.close();
        }
    }

    public String toString() {
        return "compositeDiscoveryClient(" + Arrays.stream(this.discoveryClients).map(Described::getDescription).collect(Collectors.joining(",")) + ")";
    }
}

