/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.health;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.discovery.CompositeDiscoveryClient;

@Introspected
public final class HeartbeatDiscoveryClientCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        ApplicationContext beanContext = (ApplicationContext)context.getBeanContext();
        Boolean enabled = beanContext.getProperty("micronaut.heartbeat.enabled", Boolean.class).orElse(null);
        CompositeDiscoveryClient discoveryClient = (CompositeDiscoveryClient)beanContext.getBean(CompositeDiscoveryClient.class);
        if (enabled != null && enabled.booleanValue() || ArrayUtils.isNotEmpty((Object[])discoveryClient.getDiscoveryClients())) {
            return true;
        }
        context.fail("Heartbeat not enabled since no Discovery client active");
        return false;
    }
}

