/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.scope.refresh;

import io.micronaut.aop.InterceptedProxy;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.context.scope.Refreshable;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
@Requires(notEnv={"function", "android"})
public class RefreshScope
implements CustomScope<Refreshable>,
LifeCycle<RefreshScope>,
ApplicationEventListener<RefreshEvent> {
    private final Map<String, BeanRegistration> refreshableBeans = new ConcurrentHashMap<String, BeanRegistration>(10);
    private final ConcurrentMap<Object, ReadWriteLock> locks = new ConcurrentHashMap<Object, ReadWriteLock>();
    private final BeanContext beanContext;
    private final Executor executorService;

    public RefreshScope(BeanContext beanContext, @Named(value="io") Executor executorService) {
        this.beanContext = beanContext;
        this.executorService = executorService;
    }

    public boolean isRunning() {
        return true;
    }

    public Class<Refreshable> annotationType() {
        return Refreshable.class;
    }

    public <T> T get(BeanResolutionContext resolutionContext, BeanDefinition<T> beanDefinition, BeanIdentifier identifier, Provider<T> provider) {
        BeanRegistration beanRegistration = this.refreshableBeans.computeIfAbsent(identifier.toString(), key -> {
            Object bean = provider.get();
            BeanRegistration registration = new BeanRegistration(identifier, beanDefinition, bean);
            this.locks.putIfAbsent(registration.getBean(), new ReentrantReadWriteLock());
            return registration;
        });
        return (T)beanRegistration.getBean();
    }

    public RefreshScope stop() {
        this.disposeOfAllBeans();
        this.locks.clear();
        return this;
    }

    public <T> Optional<T> remove(BeanIdentifier identifier) {
        BeanRegistration registration = this.refreshableBeans.get(identifier.toString());
        if (registration != null) {
            this.disposeOfBean(identifier.toString());
            return Optional.ofNullable(registration.getBean());
        }
        return Optional.empty();
    }

    public void onApplicationEvent(RefreshEvent event) {
        this.executorService.execute(() -> this.onRefreshEvent(event));
    }

    public final void onRefreshEvent(RefreshEvent event) {
        Object changes = event.getSource();
        if (changes == RefreshEvent.ALL_KEYS) {
            this.disposeOfAllBeans();
            this.refreshAllConfigurationProperties();
        } else {
            this.disposeOfBeanSubset(changes.keySet());
            this.refreshSubsetOfConfigurationProperties(changes.keySet());
        }
    }

    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        if (bean instanceof InterceptedProxy) {
            bean = ((InterceptedProxy)bean).interceptedTarget();
        }
        for (BeanRegistration beanRegistration : this.refreshableBeans.values()) {
            if (beanRegistration.getBean() != bean) continue;
            return Optional.of(beanRegistration);
        }
        return Optional.empty();
    }

    protected ReadWriteLock getLock(Object object) {
        ReadWriteLock readWriteLock = (ReadWriteLock)this.locks.get(object);
        if (readWriteLock == null) {
            throw new IllegalStateException("No lock present for object: " + object);
        }
        return readWriteLock;
    }

    private void refreshSubsetOfConfigurationProperties(Set<String> keySet) {
        Collection registrations = this.beanContext.getActiveBeanRegistrations(Qualifiers.byStereotype(ConfigurationProperties.class));
        for (BeanRegistration registration : registrations) {
            BeanDefinition definition = registration.getBeanDefinition();
            Optional value = definition.getValue(ConfigurationReader.class, "prefix", String.class);
            if (!value.isPresent()) continue;
            String configPrefix = (String)value.get();
            if (!keySet.stream().anyMatch(key -> key.startsWith(configPrefix))) continue;
            this.beanContext.refreshBean(registration.getIdentifier());
        }
    }

    private void refreshAllConfigurationProperties() {
        Collection registrations = this.beanContext.getActiveBeanRegistrations(Qualifiers.byStereotype(ConfigurationProperties.class));
        for (BeanRegistration registration : registrations) {
            this.beanContext.refreshBean(registration.getIdentifier());
        }
    }

    private void disposeOfBeanSubset(Collection<String> keys) {
        for (String beanKey : this.refreshableBeans.keySet()) {
            BeanRegistration beanRegistration = this.refreshableBeans.get(beanKey);
            BeanDefinition definition = beanRegistration.getBeanDefinition();
            Optional opt = definition.getValue(Refreshable.class, String[].class);
            if (opt.isPresent()) {
                Object[] strings = (String[])opt.get();
                if (!ArrayUtils.isEmpty((Object[])strings)) {
                    List<Object> prefixes = Arrays.asList(strings);
                    for (String string : prefixes) {
                        for (String k : keys) {
                            if (!k.startsWith(string)) continue;
                            this.disposeOfBean(beanKey);
                        }
                    }
                    continue;
                }
                this.disposeOfBean(beanKey);
                continue;
            }
            this.disposeOfBean(beanKey);
        }
    }

    private void disposeOfAllBeans() {
        for (String key : this.refreshableBeans.keySet()) {
            this.disposeOfBean(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeOfBean(String key) {
        BeanRegistration registration = this.refreshableBeans.remove(key);
        if (registration != null) {
            Object bean = registration.getBean();
            BeanDefinition definition = registration.getBeanDefinition();
            Lock lock = this.getLock(bean).writeLock();
            try {
                lock.lock();
                if (definition instanceof DisposableBeanDefinition) {
                    ((DisposableBeanDefinition)definition).dispose(this.beanContext, bean);
                    this.locks.remove(bean);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }
}

