/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.converters.time;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.util.StringUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;

@Singleton
@Requires(notEnv={"android"})
@BootstrapContextCompatible
@TypeHint(value={Duration.class, Instant.class, LocalDate.class, LocalDateTime.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Period.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneId.class, ZoneOffset.class}, accessType={TypeHint.AccessType.ALL_PUBLIC})
public class TimeConverterRegistrar
implements TypeConverterRegistrar {
    private static final Pattern DURATION_MATCHER = Pattern.compile("^(-?\\d+)([unsmhd])(s?)$");
    private static final int MILLIS = 3;

    public void register(ConversionService<?> conversionService) {
        conversionService.addConverter(CharSequence.class, Duration.class, (object, targetType, context) -> {
            String value = object.toString().trim();
            if (value.startsWith("P")) {
                try {
                    return Optional.of(Duration.parse(value));
                }
                catch (DateTimeParseException e) {
                    context.reject((Object)value, (Exception)e);
                    return Optional.empty();
                }
            }
            Matcher matcher = DURATION_MATCHER.matcher(value);
            if (matcher.find()) {
                String amount = matcher.group(1);
                String g2 = matcher.group(2);
                char type = g2.charAt(0);
                try {
                    String seq;
                    switch (type) {
                        case 's': {
                            return Optional.of(Duration.ofSeconds(Integer.valueOf(amount).intValue()));
                        }
                        case 'm': {
                            String ms = matcher.group(3);
                            if (StringUtils.hasText((CharSequence)ms)) {
                                return Optional.of(Duration.ofMillis(Integer.valueOf(amount).intValue()));
                            }
                            return Optional.of(Duration.ofMinutes(Integer.valueOf(amount).intValue()));
                        }
                        case 'h': {
                            return Optional.of(Duration.ofHours(Integer.valueOf(amount).intValue()));
                        }
                        case 'd': {
                            return Optional.of(Duration.ofDays(Integer.valueOf(amount).intValue()));
                        }
                    }
                    switch (seq = g2 + matcher.group(3)) {
                        case "ns": {
                            return Optional.of(Duration.ofNanos(Integer.valueOf(amount).intValue()));
                        }
                    }
                    context.reject((Object)value, (Exception)new DateTimeParseException("Unparseable date format (" + value + "). Should either be a ISO-8601 duration or a round number followed by the unit type", value, 0));
                    return Optional.empty();
                }
                catch (NumberFormatException e) {
                    context.reject((Object)value, (Exception)e);
                }
            }
            return Optional.empty();
        });
        conversionService.addConverter(CharSequence.class, LocalDateTime.class, (object, targetType, context) -> {
            try {
                DateTimeFormatter formatter = this.resolveFormatter(context);
                LocalDateTime result = LocalDateTime.parse(object, formatter);
                return Optional.of(result);
            }
            catch (DateTimeParseException e) {
                context.reject(object, (Exception)e);
                return Optional.empty();
            }
        });
        TypeConverter temporalConverter = (object, targetType, context) -> {
            try {
                DateTimeFormatter formatter = this.resolveFormatter(context);
                return Optional.of(formatter.format((TemporalAccessor)object));
            }
            catch (DateTimeParseException e) {
                context.reject(object, (Exception)e);
                return Optional.empty();
            }
        };
        conversionService.addConverter(TemporalAccessor.class, CharSequence.class, temporalConverter);
        conversionService.addConverter(CharSequence.class, LocalDate.class, (object, targetType, context) -> {
            try {
                DateTimeFormatter formatter = this.resolveFormatter(context);
                LocalDate result = LocalDate.parse(object, formatter);
                return Optional.of(result);
            }
            catch (DateTimeParseException e) {
                context.reject(object, (Exception)e);
                return Optional.empty();
            }
        });
        conversionService.addConverter(CharSequence.class, ZonedDateTime.class, (object, targetType, context) -> {
            try {
                DateTimeFormatter formatter = this.resolveFormatter(context);
                ZonedDateTime result = ZonedDateTime.parse(object, formatter);
                return Optional.of(result);
            }
            catch (DateTimeParseException e) {
                context.reject(object, (Exception)e);
                return Optional.empty();
            }
        });
        conversionService.addConverter(CharSequence.class, OffsetDateTime.class, (object, targetType, context) -> {
            try {
                DateTimeFormatter formatter = this.resolveFormatter(context);
                OffsetDateTime result = OffsetDateTime.parse(object, formatter);
                return Optional.of(result);
            }
            catch (DateTimeParseException e) {
                context.reject(object, (Exception)e);
                return Optional.empty();
            }
        });
    }

    private DateTimeFormatter resolveFormatter(ConversionContext context) {
        Optional format = context.getAnnotationMetadata().getValue(Format.class, String.class);
        return format.map(pattern -> DateTimeFormatter.ofPattern(pattern, context.getLocale())).orElse(DateTimeFormatter.RFC_1123_DATE_TIME);
    }
}

