/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.scheduling.instrument.InstrumentedExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public interface InstrumentedExecutorService
extends ExecutorService,
InstrumentedExecutor {
    @Override
    public ExecutorService getTarget();

    default public <T> Callable<T> instrument(Callable<T> task) {
        return task;
    }

    @Override
    default public void shutdown() {
        this.getTarget().shutdown();
    }

    @Override
    default public List<Runnable> shutdownNow() {
        return this.getTarget().shutdownNow();
    }

    @Override
    default public boolean isShutdown() {
        return this.getTarget().isShutdown();
    }

    @Override
    default public boolean isTerminated() {
        return this.getTarget().isTerminated();
    }

    @Override
    default public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.getTarget().awaitTermination(timeout, unit);
    }

    @Override
    @Nonnull
    default public <T> Future<T> submit(@Nonnull Callable<T> task) {
        return this.getTarget().submit(this.instrument(task));
    }

    @Override
    @Nonnull
    default public <T> Future<T> submit(@Nonnull Runnable task, T result) {
        return this.getTarget().submit(this.instrument(task), result);
    }

    @Override
    @Nonnull
    default public Future<?> submit(@Nonnull Runnable task) {
        return this.getTarget().submit(this.instrument(task));
    }

    @Override
    @Nonnull
    default public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getTarget().invokeAll(tasks.stream().map(this::instrument).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    default public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.getTarget().invokeAll(tasks.stream().map(this::instrument).collect(Collectors.toList()), timeout, unit);
    }

    @Override
    @Nonnull
    default public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getTarget().invokeAny(tasks.stream().map(this::instrument).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    default public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getTarget().invokeAny(tasks.stream().map(this::instrument).collect(Collectors.toList()), timeout, unit);
    }
}

