/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.annotation;

import io.micronaut.aop.Around;
import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Type;
import io.micronaut.retry.annotation.Retryable;
import io.micronaut.retry.intercept.DefaultRetryInterceptor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.constraints.Digits;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Around
@Type(value={DefaultRetryInterceptor.class})
public @interface CircuitBreaker {
    public static final int MAX_RETRY_ATTEMPTS = 4;

    @AliasFor(annotation=Retryable.class, member="includes")
    public Class<? extends Throwable>[] includes() default {};

    @AliasFor(annotation=Retryable.class, member="excludes")
    public Class<? extends Throwable>[] excludes() default {};

    @Digits(integer=4, fraction=0)
    @AliasFor(annotation=Retryable.class, member="attempts")
    public @Digits(integer=4, fraction=0) String attempts() default "3";

    @AliasFor(annotation=Retryable.class, member="delay")
    public String delay() default "500ms";

    @Digits(integer=2, fraction=2)
    @AliasFor(annotation=Retryable.class, member="multiplier")
    public @Digits(integer=2, fraction=2) String multiplier() default "0";

    @AliasFor(annotation=Retryable.class, member="maxDelay")
    public String maxDelay() default "5s";

    public String reset() default "20s";
}

