/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumentedObserver;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.observables.ConnectableObservable;
import java.util.Collection;
import java.util.List;

@Internal
final class RxInstrumentedConnectableObservable<T>
extends ConnectableObservable<T>
implements RxInstrumentedComponent {
    private final ConnectableObservable<T> source;
    private final List<RunnableInstrumenter> instrumentations;

    RxInstrumentedConnectableObservable(ConnectableObservable<T> source, List<RunnableInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = instrumentations;
    }

    RxInstrumentedConnectableObservable(ConnectableObservable<T> source, Collection<ReactiveInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    protected void subscribeActual(Observer<? super T> o) {
        this.source.subscribe(new RxInstrumentedObserver<T>(o, this.instrumentations));
    }

    public void connect(Consumer<? super Disposable> connection) {
        Runnable onConnect = () -> this.source.connect(connection);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onConnect = instrumentation.instrument(onConnect);
        }
        onConnect.run();
    }
}

