/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumentedWrappers;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedFlowable<T>
extends Flowable<T>
implements RxInstrumentedComponent {
    private final Publisher<T> source;
    private final List<RunnableInstrumenter> instrumentations;

    RxInstrumentedFlowable(Publisher<T> source, List<RunnableInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = instrumentations;
    }

    RxInstrumentedFlowable(Publisher<T> source, Collection<ReactiveInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        if (!(s instanceof FlowableSubscriber)) {
            throw new IllegalArgumentException("Subscriber must be an instance of FlowableSubscriber");
        }
        this.source.subscribe(RxInstrumentedWrappers.wrap(s, this.instrumentations));
    }
}

