/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumentedWrappers;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.parallel.ParallelFlowable;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedParallelFlowable<T>
extends ParallelFlowable<T>
implements RxInstrumentedComponent {
    protected final ParallelFlowable<T> source;
    private final List<RunnableInstrumenter> instrumentations;

    RxInstrumentedParallelFlowable(ParallelFlowable<T> source, List<RunnableInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = instrumentations;
    }

    RxInstrumentedParallelFlowable(ParallelFlowable<T> source, Collection<ReactiveInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    public int parallelism() {
        return this.source.parallelism();
    }

    public void subscribe(Subscriber<? super T>[] s) {
        if (!this.validate(s)) {
            return;
        }
        int n = s.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> z = s[i];
            parents[i] = RxInstrumentedWrappers.wrap(z, this.instrumentations);
        }
        this.source.subscribe(parents);
    }
}

