/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.operation.migrate;

import io.mongock.api.config.executor.ChangeExecutorConfiguration;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.runner.core.executor.ChangeExecutorBase;
import io.mongock.runner.core.executor.changelog.ChangeLogRuntime;
import io.mongock.runner.core.executor.changelog.ChangeLogServiceBase;
import io.mongock.runner.core.internal.ChangeLogItem;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class MigrateExecutorBase
extends ChangeExecutorBase<ChangeExecutorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(MigrateExecutorBase.class);

    public MigrateExecutorBase(String executionId, ChangeLogServiceBase changeLogService, ConnectionDriver driver, ChangeLogRuntime changeLogRuntime, Function<AnnotatedElement, Boolean> annotationFilter, ChangeExecutorConfiguration config) {
        super(executionId, changeLogService, driver, changeLogRuntime, annotationFilter, config.getMetadata(), config.getServiceIdentifier(), config.isTrackIgnored(), config.getTransactionEnabled(), config.getTransactionStrategy(), config);
    }

    /*
     * Loose catch block
     */
    @Override
    public Boolean executeMigration() {
        this.initializationAndValidation();
        Collection<ChangeLogItem> changeLogs = this.fetchAndPrepareChangeLogs();
        try {
            if (changeLogs == null || changeLogs.isEmpty()) {
                logger.info("Mongock skipping the data migration. There is no change set item.");
                Boolean bl = false;
                return bl;
            }
            this.loadExecutedChangeEntries();
            if (!this.isThereAnyChangeSetItemToBeExecuted(changeLogs)) {
                logger.info("Mongock skipping the data migration. All change set items are already executed.");
                this.logIgnoredChangeLogs(changeLogs);
                Boolean bl = false;
                return bl;
            }
            try (LockManager lockManager = this.driver.getLockManager();){
                lockManager.acquireLockDefault();
                this.loadExecutedChangeEntries();
                String executionHostname = this.generateExecutionHostname(this.executionId);
                logger.info("Mongock starting the data migration sequence id[{}]...", (Object)this.executionId);
                this.processMigration(changeLogs, this.executionId, executionHostname);
                Boolean bl = true;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.executionInProgress = false;
            logger.info("Mongock has finished");
        }
    }

    protected Collection<ChangeLogItem> fetchAndPrepareChangeLogs() {
        return this.changeLogService.fetchChangeLogs();
    }

    @Override
    protected void validateChangeLog(ChangeLogItem changeLog) {
        if (changeLog.isSystem()) {
            logger.warn("Invalid ChangeUnit[{}]. System changeUnits are only allowed for internal purposes. It will be treated as not system change.", (Object)changeLog.getId());
            changeLog.setSystem(false);
        }
    }
}

