/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.tiles;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.example.http2.tiles.Http2RequestHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;

public final class Http1RequestHandler
extends Http2RequestHandler {
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER));
        }
        super.channelRead0(ctx, request);
    }

    @Override
    protected void sendResponse(final ChannelHandlerContext ctx, String streamId, int latency, final FullHttpResponse response, final FullHttpRequest request) {
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (HttpUtil.isKeepAlive((HttpMessage)request)) {
                    if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
                        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                    }
                    ctx.writeAndFlush((Object)response);
                } else {
                    response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
        }, (long)latency, TimeUnit.MILLISECONDS);
    }
}

