/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.file;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http2.file.Http2StaticFileServerHandler;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;

public class Http2StaticFileServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;

    public Http2StaticFileServerInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        pipeline.addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new Http2StaticFileServerHandler()});
    }
}

