/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.discard;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.discard.DiscardClient;
import io.netty.util.concurrent.GenericFutureListener;

public class DiscardClientHandler
extends SimpleChannelInboundHandler<Object> {
    private ByteBuf content;
    private ChannelHandlerContext ctx;
    long counter;
    private final ChannelFutureListener trafficGenerator = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            if (future.isSuccess()) {
                DiscardClientHandler.this.generateTraffic();
            } else {
                future.cause().printStackTrace();
                future.channel().close();
            }
        }
    };

    public void channelActive(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.content = ctx.alloc().directBuffer(DiscardClient.SIZE).writeZero(DiscardClient.SIZE);
        this.generateTraffic();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.content.release();
    }

    public void messageReceived(ChannelHandlerContext ctx, Object msg) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    private void generateTraffic() {
        this.ctx.writeAndFlush((Object)this.content.duplicate().retain()).addListener((GenericFutureListener)this.trafficGenerator);
    }
}

