/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.bytes.ByteEchoServerHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultExecutorServiceFactory;
import io.netty.util.concurrent.ExecutorServiceFactory;

public final class ByteEchoServer {
    static final int PORT = Integer.parseInt(System.getProperty("port", "8007"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DefaultExecutorServiceFactory acceptFactory = new DefaultExecutorServiceFactory("accept");
        DefaultExecutorServiceFactory connectFactory = new DefaultExecutorServiceFactory("connect");
        NioEventLoopGroup acceptGroup = new NioEventLoopGroup(1, (ExecutorServiceFactory)acceptFactory, NioUdtProvider.BYTE_PROVIDER);
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ExecutorServiceFactory)connectFactory, NioUdtProvider.BYTE_PROVIDER);
        try {
            ServerBootstrap boot = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boot.group((EventLoopGroup)acceptGroup, (EventLoopGroup)connectGroup).channelFactory(NioUdtProvider.BYTE_ACCEPTOR)).option(ChannelOption.SO_BACKLOG, (Object)10)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new ByteEchoServerHandler()});
                }
            });
            ChannelFuture future = boot.bind(PORT).sync();
            future.channel().closeFuture().sync();
        }
        finally {
            acceptGroup.shutdownGracefully();
            connectGroup.shutdownGracefully();
        }
    }
}

