/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public final class DnsCacheEntry {
    private final String hostname;
    private final InetAddress address;
    private final Throwable cause;
    private volatile ScheduledFuture<?> expirationFuture;

    public DnsCacheEntry(String hostname, InetAddress address) {
        this.hostname = (String)ObjectUtil.checkNotNull((Object)hostname, (String)"hostname");
        this.address = (InetAddress)ObjectUtil.checkNotNull((Object)address, (String)"address");
        this.cause = null;
    }

    public DnsCacheEntry(String hostname, Throwable cause) {
        this.hostname = (String)ObjectUtil.checkNotNull((Object)hostname, (String)"hostname");
        this.cause = (Throwable)ObjectUtil.checkNotNull((Object)cause, (String)"cause");
        this.address = null;
    }

    public String hostname() {
        return this.hostname;
    }

    public InetAddress address() {
        return this.address;
    }

    public Throwable cause() {
        return this.cause;
    }

    void scheduleExpiration(EventLoop loop, Runnable task, long delay, TimeUnit unit) {
        assert (this.expirationFuture == null) : "expiration task scheduled already";
        this.expirationFuture = loop.schedule(task, delay, unit);
    }

    void cancelExpiration() {
        ScheduledFuture<?> expirationFuture = this.expirationFuture;
        if (expirationFuture != null) {
            expirationFuture.cancel(false);
        }
    }

    public String toString() {
        if (this.cause != null) {
            return this.hostname + '/' + this.cause;
        }
        return this.address.toString();
    }
}

