/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni.socket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLExt;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.socket.AprSocketContext;
import org.apache.tomcat.jni.socket.HostInfo;

public class AprSocket
implements Runnable {
    private static final Logger log = Logger.getLogger("org.apache.tomcat.jni.socket.AprSocket");
    private static final byte[][] NO_CERTS = new byte[0][];
    static final int CONNECTING = 1;
    static final int CONNECTED = 2;
    static final int POLLIN_ACTIVE = 4;
    static final int POLLOUT_ACTIVE = 8;
    static final int POLL = 16;
    static final int SSL_ATTACHED = 64;
    static final int POLLIN = 128;
    static final int POLLOUT = 256;
    static final int ACCEPTED = 512;
    static final int ERROR = 1024;
    static final int CLOSED = 2048;
    static final int READING = 4096;
    static final int WRITING = 8192;
    private final AprSocketContext context;
    AprSocketContext.BlockingPollHandler handler;
    AprSocketContext.AprPoller poller;
    private int status;
    long socket;
    private HostInfo hostInfo;

    AprSocket(AprSocketContext context) {
        this.context = context;
    }

    public void recycle() {
        this.status = 0;
        this.hostInfo = null;
        this.handler = null;
        this.socket = 0L;
        this.poller = null;
    }

    public String toString() {
        return (this.context.isServer() ? "AprSrv-" : "AprCli-") + Long.toHexString(this.socket) + " " + Integer.toHexString(this.status);
    }

    public void setHandler(AprSocketContext.BlockingPollHandler l) {
        this.handler = l;
    }

    private void setNonBlocking() {
        if (this.socket != 0L && this.context.running) {
            Socket.optSet(this.socket, 8, 1);
            Socket.timeoutSet(this.socket, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            return (this.status & 0x10) != 0;
        }
    }

    public AprSocketContext.BlockingPollHandler getHandler() {
        return this.handler;
    }

    public AprSocketContext getContext() {
        return this.context;
    }

    AprSocket setHost(HostInfo hi) {
        this.hostInfo = hi;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (this.isBlocking()) {
            this.context.connectBlocking(this);
        } else {
            AprSocket aprSocket = this;
            synchronized (aprSocket) {
                if ((this.status & 1) != 0) {
                    return;
                }
                this.status |= 1;
            }
            this.context.connectExecutor.execute(this);
        }
    }

    void afterConnect() throws IOException {
        if (this.hostInfo.secure) {
            this.blockingStartTLS();
        }
        this.setNonBlocking();
        this.setStatus(2);
        this.clearStatus(1);
        this.notifyConnected(false);
    }

    public HostInfo getHost() {
        return this.hostInfo;
    }

    public int write(byte[] data, int off, int len, long to) throws IOException {
        long max = System.currentTimeMillis() + to;
        while (true) {
            int rc;
            if ((rc = this.writeInternal(data, off, len)) < 0) {
                throw new IOException("Write error " + rc);
            }
            if (rc != 0) {
                return rc;
            }
            this.context.findPollerAndAdd(this);
            try {
                long waitTime = max - System.currentTimeMillis();
                if (waitTime <= 0L) {
                    return 0;
                }
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] data, int off, int len) throws IOException {
        int rc = this.writeInternal(data, off, len);
        if (rc < 0) {
            throw new IOException("Write error " + rc);
        }
        if (rc == 0) {
            AprSocket aprSocket = this;
            synchronized (aprSocket) {
                this.context.findPollerAndAdd(this);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeInternal(byte[] data, int off, int len) throws IOException {
        int rt = 0;
        int sent = 0;
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            if ((this.status & 0x800) != 0 || this.socket == 0L || !this.context.running) {
                throw new IOException("Closed");
            }
            if ((this.status & 0x2000) != 0) {
                throw new IOException("Write from 2 threads not allowed");
            }
            this.status |= 0x2000;
            while (len > 0 && (sent = Socket.send(this.socket, data, off, len)) > 0) {
                off += sent;
                len -= sent;
            }
            this.status &= 0xFFFFDFFF;
        }
        if (this.context.rawDataHandler != null) {
            this.context.rawData(this, false, data, off, sent, len, false);
        }
        if (sent <= 0) {
            if (sent == -120001 || sent == -120002 || sent == 0) {
                this.setStatus(256);
                this.updatePolling();
                return rt;
            }
            log.warning("apr.send(): Failed to send, closing " + sent);
            this.reset();
            throw new IOException("Error sending " + sent + " " + Error.strerror(-sent));
        }
        off += sent;
        len -= sent;
        rt += sent;
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] data, int off, int len, long to) throws IOException {
        int rd = this.readNB(data, off, len);
        if (rd == 0) {
            AprSocket aprSocket = this;
            synchronized (aprSocket) {
                try {
                    this.wait(to);
                }
                catch (InterruptedException e) {
                    return 0;
                }
            }
            rd = this.readNB(data, off, len);
        }
        return this.processReadResult(data, off, len, rd);
    }

    public int read(byte[] data, int off, int len) throws IOException {
        return this.readNB(data, off, len);
    }

    private int processReadResult(byte[] data, int off, int len, int read) throws IOException {
        if (this.context.rawDataHandler != null) {
            this.context.rawData(this, true, data, off, read, len, false);
        }
        if (read > 0) {
            return read;
        }
        if (read == 0 || read == -120001 || read == -120005 || read == -120002) {
            read = 0;
            this.setStatus(128);
            this.updatePolling();
            return 0;
        }
        if (read == -70014 || read == -1) {
            this.close();
            return -1;
        }
        this.reset();
        throw new IOException("apr.read(): " + read + " " + Error.strerror(-read));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readNB(byte[] data, int off, int len) throws IOException {
        int read;
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            if ((this.status & 0x800) != 0 || this.socket == 0L || !this.context.running) {
                return -1;
            }
            if ((this.status & 0x1000) != 0) {
                throw new IOException("Read from 2 threads not allowed");
            }
            this.status |= 0x1000;
            read = Socket.recv(this.socket, data, off, len);
            this.status &= 0xFFFFEFFF;
        }
        return this.processReadResult(data, off, len, read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            if ((this.status & 0x800) != 0 || this.socket == 0L) {
                return;
            }
            this.status |= 0x800;
            this.status &= 0xFFFFFF7F;
            this.status &= 0xFFFFFEFF;
        }
        if (this.context.rawDataHandler != null) {
            this.context.rawDataHandler.rawData(this, false, null, 0, 0, 0, true);
        }
        Socket.close(this.socket);
        if (this.poller == null) {
            this.maybeDestroy();
        } else {
            try {
                this.poller.requestUpdate(this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeDestroy() {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            if (this.socket == 0L || (this.status & 1) != 0 || !this.context.running) {
                return;
            }
            if ((this.status & 0x800) == 0) {
                return;
            }
            if ((this.status & 0x3000) != 0) {
                return;
            }
            if (this.context.rawDataHandler != null) {
                this.context.rawDataHandler.rawData(this, false, null, -1, -1, -1, true);
            }
            if (log.isLoggable(Level.FINE)) {
                log.info("closing: context.open=" + this.context.open.get() + " " + this);
            }
            this.context.open.decrementAndGet();
            if (this.socket != 0L && (this.status & 0x800) == 0) {
                Socket.close(this.socket);
                this.status |= 0x800;
            }
            if (this.handler != null) {
                if (this.isBlocking()) {
                    this.context.getExecutor().execute(this);
                } else {
                    this.handler.closed(this);
                }
            }
            this.context.destroySocket(this);
        }
    }

    public void reset() {
        this.setStatus(1024);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            return (this.status & 0x800) != 0 || this.socket == 0L || !this.context.running;
            {
            }
        }
    }

    public long getIOTimeout() throws IOException {
        if (this.socket != 0L && this.context.running) {
            try {
                return Socket.timeoutGet(this.socket) / 1000L;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        throw new IOException("Socket is closed");
    }

    public byte[][] getPeerCert(boolean check) throws IOException {
        this.getHost();
        if (this.hostInfo.certs != null && this.hostInfo.certs != NO_CERTS && !check) {
            return this.hostInfo.certs;
        }
        if (!this.checkBitAndSocket(64)) {
            return NO_CERTS;
        }
        try {
            int certLength = SSLSocket.getInfoI(this.socket, 1024);
            if (certLength <= 0) {
                if (this.hostInfo.certs == null) {
                    this.hostInfo.certs = NO_CERTS;
                }
                return this.hostInfo.certs;
            }
            this.hostInfo.certs = new byte[certLength + 1][];
            this.hostInfo.certs[0] = SSLSocket.getInfoB(this.socket, 263);
            for (int i = 0; i < certLength; ++i) {
                this.hostInfo.certs[i + 1] = SSLSocket.getInfoB(this.socket, 1024 + i);
            }
            return this.hostInfo.certs;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public X509Certificate[] getPeerX509Cert() throws IOException {
        byte[][] certs = this.getPeerCert(false);
        X509Certificate[] xcerts = new X509Certificate[certs.length];
        if (certs.length == 0) {
            return xcerts;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i] == null) continue;
                ByteArrayInputStream bis = new ByteArrayInputStream(certs[i]);
                xcerts[i] = (X509Certificate)cf.generateCertificate(bis);
                bis.close();
            }
        }
        catch (CertificateException ex) {
            throw new IOException(ex);
        }
        return xcerts;
    }

    public String getCipherSuite() throws IOException {
        if (this.checkBitAndSocket(64)) {
            return null;
        }
        try {
            return SSLSocket.getInfoS(this.socket, 2);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public int getKeySize() throws IOException {
        if (this.checkBitAndSocket(64)) {
            return -1;
        }
        try {
            return SSLSocket.getInfoI(this.socket, 3);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public int getRemotePort() throws IOException {
        if (this.socket != 0L && this.context.running) {
            try {
                long sa = Address.get(1, this.socket);
                Sockaddr addr = Address.getInfo(sa);
                return addr.port;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException("Socket closed");
    }

    public String getRemoteAddress() throws IOException {
        if (this.socket != 0L && this.context.running) {
            try {
                long sa = Address.get(1, this.socket);
                return Address.getip(sa);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException("Socket closed");
    }

    public String getRemoteHostname() throws IOException {
        if (this.socket != 0L && this.context.running) {
            try {
                long sa = Address.get(1, this.socket);
                String remoteHost = Address.getnameinfo(sa, 0);
                if (remoteHost == null) {
                    remoteHost = Address.getip(sa);
                }
                return remoteHost;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException("Socket closed");
    }

    public int getLocalPort() throws IOException {
        if (this.socket != 0L && this.context.running) {
            try {
                long sa = Address.get(0, this.socket);
                Sockaddr addr = Address.getInfo(sa);
                return addr.port;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException("Socket closed");
    }

    public String getLocalAddress() throws IOException {
        if (this.socket != 0L && this.context.running) {
            try {
                long sa = Address.get(0, this.socket);
                return Address.getip(sa);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException("Socket closed");
    }

    public String getLocalHostname() throws IOException {
        if (this.socket != 0L && this.context.running) {
            try {
                long sa = Address.get(0, this.socket);
                return Address.getnameinfo(sa, 0);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException("Socket closed");
    }

    public boolean isBlocking() {
        return !(this.handler instanceof AprSocketContext.NonBlockingPollHandler);
    }

    public boolean isError() {
        return this.checkPreConnect(1024);
    }

    void notifyError(Throwable err, boolean needsThread) {
        if (this.handler instanceof AprSocketContext.NonBlockingPollHandler) {
            if (err != null) {
                ((AprSocketContext.NonBlockingPollHandler)this.handler).error(this, err);
            }
        } else if (needsThread) {
            this.context.getExecutor().execute(this);
        } else {
            try {
                this.notifyIO();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, this + " error ", e);
            }
        }
    }

    void notifyIO() throws IOException {
        long t0 = System.currentTimeMillis();
        try {
            if (this.handler != null) {
                this.handler.process(this, true, false, false);
            }
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        finally {
            long t1 = System.currentTimeMillis();
            if ((t1 -= t0) > this.context.maxHandlerTime.get()) {
                this.context.maxHandlerTime.set(t1);
            }
            this.context.totalHandlerTime.addAndGet(t1);
            this.context.handlerCount.incrementAndGet();
        }
    }

    private void notifyConnected(boolean server) throws IOException {
        this.context.onSocket(this);
        if (this.handler instanceof AprSocketContext.NonBlockingPollHandler) {
            ((AprSocketContext.NonBlockingPollHandler)this.handler).connected(this);
            ((AprSocketContext.NonBlockingPollHandler)this.handler).process(this, true, true, false);
            this.updatePolling();
        } else if (server) {
            this.notifyIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePolling() throws IOException {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            if ((this.status & 0x800) != 0) {
                this.maybeDestroy();
                return;
            }
        }
        this.context.findPollerAndAdd(this);
    }

    @Override
    public void run() {
        if (!this.context.running) {
            return;
        }
        if (this.checkPreConnect(2048)) {
            if (this.handler != null) {
                this.handler.closed(this);
            }
            return;
        }
        if (!this.checkPreConnect(2)) {
            if (this.checkBitAndSocket(512)) {
                try {
                    this.context.open.incrementAndGet();
                    if (log.isLoggable(Level.FINE)) {
                        log.info("Accept: " + this.context.open.get() + " " + this + " " + this.getRemotePort());
                    }
                    if (this.context.tcpNoDelay) {
                        Socket.optSet(this.socket, 512, 1);
                    }
                    this.setStatus(2);
                    if (this.context.sslMode) {
                        this.context.getClass();
                        Socket.timeoutSet(this.socket, 20000L * 1000L);
                        this.blockingStartTLS();
                    }
                    this.setNonBlocking();
                    this.notifyConnected(true);
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.reset();
                    this.notifyError(t, false);
                    return;
                }
            }
            if (this.checkPreConnect(1)) {
                try {
                    this.context.connectBlocking(this);
                }
                catch (IOException t) {
                    this.reset();
                    if (this.handler instanceof AprSocketContext.NonBlockingPollHandler) {
                        ((AprSocketContext.NonBlockingPollHandler)this.handler).process(this, false, false, true);
                    }
                    this.notifyError(t, false);
                }
            }
        } else if (this.handler != null) {
            try {
                this.notifyIO();
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, this + " error ", e);
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockingStartTLS() throws IOException {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            if (this.socket == 0L || !this.context.running) {
                return;
            }
            if ((this.status & 0x40) != 0) {
                return;
            }
            this.status |= 0x40;
        }
        try {
            if (log.isLoggable(Level.FINE)) {
                log.info(this + " StartSSL");
            }
            AprSocketContext aprCon = this.context;
            SSLSocket.attach(aprCon.getSslCtx(), this.socket);
            this.context.getClass();
            if (!this.getContext().isServer()) {
                if (this.context.USE_TICKETS && this.hostInfo.ticketLen > 0) {
                    SSLExt.setTicket(this.socket, this.hostInfo.ticket, this.hostInfo.ticketLen);
                } else if (this.hostInfo.sessDer != null) {
                    SSLExt.setSessionData(this.socket, this.hostInfo.sessDer, this.hostInfo.sessDer.length);
                }
            }
            SSLExt.sslSetMode(this.socket, 3L);
            int rc = SSLSocket.handshake(this.socket);
            if (this.hostInfo == null) {
                this.hostInfo = new HostInfo();
            }
            if (rc != 0) {
                throw new IOException(this + " Handshake failed " + rc + " " + Error.strerror(rc) + " SSLL " + SSL.getLastError());
            }
            this.handshakeDone();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void handshakeDone() throws IOException {
        this.getHost();
        if (this.socket == 0L || !this.context.running) {
            throw new IOException("Socket closed");
        }
        if (this.context.USE_TICKETS && !this.context.isServer()) {
            int ticketLen;
            if (this.hostInfo.ticket == null) {
                this.hostInfo.ticket = new byte[2048];
            }
            if ((ticketLen = SSLExt.getTicket(this.socket, this.hostInfo.ticket)) > 0) {
                this.hostInfo.ticketLen = ticketLen;
                if (log.isLoggable(Level.FINE)) {
                    log.info("Received ticket: " + ticketLen);
                }
            }
        }
        try {
            this.hostInfo.sessDer = SSLExt.getSessionData(this.socket);
            this.getPeerCert(true);
            this.hostInfo.sessionId = SSLSocket.getInfoS(this.socket, 1);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.hostInfo.npn = new byte[32];
        this.hostInfo.npnLen = SSLExt.getNPN(this.socket, this.hostInfo.npn);
        if (this.context.tlsCertVerifier != null) {
            this.context.tlsCertVerifier.handshakeDone(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int requestedPolling() {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            if (this.socket == 0L || (this.status & 0x800) != 0) {
                return 0;
            }
            int res = 0;
            if ((this.status & 0x80) != 0) {
                res = 1;
            }
            if ((this.status & 0x100) != 0) {
                res |= 4;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkBitAndSocket(int bit) {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            return (this.status & bit) != 0 && this.socket != 0L && (this.status & 0x800) == 0 && this.context.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPreConnect(int bit) {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            return (this.status & bit) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStatus(int bit) {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            this.status &= ~bit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setStatus(int bit) {
        AprSocket aprSocket = this;
        synchronized (aprSocket) {
            int old = this.status & bit;
            this.status |= bit;
            return old != 0;
        }
    }
}

