/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.config.db;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.config.db.DatabaseConfiguration;
import io.nflow.engine.internal.storage.db.DatabaseInitializer;
import io.nflow.engine.internal.storage.db.MySQLVariants;
import io.nflow.engine.internal.storage.db.SQLVariants;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceUtils;

@Profile(value={"nflow.db.mysql"})
@Configuration
public class MysqlDatabaseConfiguration
extends DatabaseConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MysqlDatabaseConfiguration.class);

    public MysqlDatabaseConfiguration() {
        super("mysql");
    }

    @Override
    @Bean
    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="exception message is ok, null-check in try-catch")
    public DatabaseInitializer nflowDatabaseInitializer(@NFlow DataSource nflowDataSource, Environment env) {
        String scriptPrefix = "mysql";
        try (Connection c = DataSourceUtils.getConnection((DataSource)nflowDataSource);){
            DatabaseMetaData meta = c.getMetaData();
            String databaseProductVersion = meta.getDatabaseProductVersion();
            int majorVersion = meta.getDatabaseMajorVersion();
            int minorVersion = meta.getDatabaseMinorVersion();
            logger.info("MySQL {}.{}, product version {}", new Object[]{majorVersion, minorVersion, databaseProductVersion});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to obtain MySQL version", e);
        }
        return new DatabaseInitializer(scriptPrefix, nflowDataSource, env, ";");
    }

    @Override
    @Bean
    public SQLVariants sqlVariants(Environment env) {
        return new MySQLVariants();
    }
}

