/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.exception;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.exception.DispatcherExceptionHandling;
import io.nflow.engine.internal.dao.PollingBatchException;
import io.nflow.engine.internal.dao.PollingRaceConditionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.stereotype.Component;

@Component
public class DispatcherExceptionAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(DispatcherExceptionAnalyzer.class);

    public final DispatcherExceptionHandling analyzeSafely(Exception e) {
        try {
            return this.analyze(e);
        }
        catch (Exception analyzerException) {
            logger.error("Failed to analyze exception, using default handling.", (Throwable)analyzerException);
            return this.getDefaultHandling(e);
        }
    }

    protected DispatcherExceptionHandling analyze(Exception e) {
        return this.getDefaultHandling(e);
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"}, justification="Not avoidable here")
    private DispatcherExceptionHandling getDefaultHandling(Exception e) {
        DispatcherExceptionHandling.Builder builder = new DispatcherExceptionHandling.Builder();
        if (e instanceof PollingRaceConditionException) {
            ((DispatcherExceptionHandling.Builder)((DispatcherExceptionHandling.Builder)builder.setLogLevel(Level.DEBUG)).setLogStackTrace(false)).setRandomizeSleep(true);
        } else if (e instanceof PollingBatchException) {
            ((DispatcherExceptionHandling.Builder)((DispatcherExceptionHandling.Builder)builder.setLogLevel(Level.WARN)).setLogStackTrace(false)).setSleep(false);
        } else if (e instanceof InterruptedException) {
            builder.setLog(false).setSleep(false);
        }
        return builder.build();
    }
}

