/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.executor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.executor.ThresholdBlockingQueue;
import io.nflow.engine.internal.executor.WorkflowStateProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInstanceExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowInstanceExecutor.class);
    private final int awaitTerminationSeconds;
    private final int threadCount;
    final ThreadPoolExecutor executor;
    final ThresholdBlockingQueue<Runnable> queue;

    public WorkflowInstanceExecutor(int maxQueueSize, int threadCount, int notifyThreshold, int awaitTerminationSeconds, int keepAliveSeconds, ThreadFactory threadFactory) {
        this.queue = new ThresholdBlockingQueue(maxQueueSize, notifyThreshold);
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, (long)keepAliveSeconds, TimeUnit.SECONDS, this.queue, threadFactory);
        this.executor.allowCoreThreadTimeOut(keepAliveSeconds > 0);
        this.awaitTerminationSeconds = awaitTerminationSeconds;
        this.threadCount = threadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void waitUntilQueueSizeLowerThanThreshold(DateTime waitUntil) throws InterruptedException {
        this.queue.waitUntilQueueSizeLowerThanThreshold(waitUntil);
    }

    public void wakeUpDispatcherIfNeeded() {
        this.queue.notifyIfNotFull();
    }

    public void execute(WorkflowStateProcessor runnable) {
        this.executor.execute(runnable);
    }

    public int getQueueRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public boolean shutdown(Consumer<List<Long>> clearExecutorIds, boolean allowInterrupt) {
        boolean gracefulShutdownSucceeded;
        long totalTimeoutMs = TimeUnit.SECONDS.toMillis(this.awaitTerminationSeconds);
        long hardTimeoutMs = allowInterrupt ? Math.min(5000L, totalTimeoutMs / 3L) : 0L;
        long gracefulTimeoutMs = totalTimeoutMs - hardTimeoutMs;
        this.executor.shutdown();
        ArrayList<Runnable> queuedWorkflows = new ArrayList<Runnable>();
        this.queue.drainTo(queuedWorkflows);
        boolean executorIdsCleared = this.clearExecutorIds(queuedWorkflows, clearExecutorIds);
        try {
            if (!this.executor.awaitTermination(gracefulTimeoutMs, TimeUnit.MILLISECONDS)) {
                logger.warn("Graceful shutdown timed out after {} ms while waiting for workflow processing to complete normally", (Object)gracefulTimeoutMs);
                if (allowInterrupt) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(hardTimeoutMs, TimeUnit.MILLISECONDS)) {
                        logger.warn("Hard shutdown timed out after {} ms while waiting for interrupted workflow processing to complete", (Object)hardTimeoutMs);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            logger.warn("Interrupted while waiting for executor to terminate");
            Thread.currentThread().interrupt();
        }
        boolean bl = gracefulShutdownSucceeded = executorIdsCleared && this.executor.isTerminated();
        if (gracefulShutdownSucceeded) {
            logger.info("Graceful shutdown succeeded");
        }
        return gracefulShutdownSucceeded;
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_RETURN_FALSE"}, justification="Shutdown error handling only needs the boolean")
    private boolean clearExecutorIds(List<Runnable> workflows, Consumer<List<Long>> clearExecutorIds) {
        if (workflows.isEmpty()) {
            return true;
        }
        try {
            List<Runnable> wfs = workflows;
            clearExecutorIds.accept(wfs.stream().map(w -> w.instanceId).collect(Collectors.toList()));
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to clear executorIds of queued workflows", (Throwable)e);
            return false;
        }
    }
}

