/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.internal.workflow.WorkflowInstancePreProcessor;
import io.nflow.engine.service.NflowNotFoundException;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.instance.QueryWorkflowInstances;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class WorkflowInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowInstanceService.class);
    private static final WorkflowInstance.WorkflowInstanceStatus[] UNFINISHED_STATUSES = EnumSet.complementOf(EnumSet.of(WorkflowInstance.WorkflowInstanceStatus.finished)).toArray(new WorkflowInstance.WorkflowInstanceStatus[0]);
    private final WorkflowDefinitionService workflowDefinitionService;
    private final WorkflowInstanceDao workflowInstanceDao;
    private final WorkflowInstancePreProcessor workflowInstancePreProcessor;

    @Inject
    public WorkflowInstanceService(WorkflowInstanceDao workflowInstanceDao, WorkflowDefinitionService workflowDefinitionService, WorkflowInstancePreProcessor workflowInstancePreProcessor) {
        this.workflowInstanceDao = workflowInstanceDao;
        this.workflowDefinitionService = workflowDefinitionService;
        this.workflowInstancePreProcessor = workflowInstancePreProcessor;
    }

    public WorkflowInstance getWorkflowInstance(long id, Set<WorkflowInstanceInclude> includes, Long maxActions) {
        return this.getWorkflowInstance(id, includes, maxActions, false);
    }

    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="NflowNotFoundException message is ok")
    public WorkflowInstance getWorkflowInstance(long id, Set<WorkflowInstanceInclude> includes, Long maxActions, boolean queryArchive) {
        try {
            return this.workflowInstanceDao.getWorkflowInstance(id, includes, maxActions, queryArchive);
        }
        catch (EmptyResultDataAccessException e) {
            throw new NflowNotFoundException("Workflow instance", id, e);
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="getInitialState().toString() has no cast")
    public long insertWorkflowInstance(WorkflowInstance instance) {
        Assert.notNull((Object)this.workflowInstancePreProcessor, (String)"workflowInstancePreProcessor can not be null");
        WorkflowInstance processedInstance = this.workflowInstancePreProcessor.process(instance);
        long id = this.workflowInstanceDao.insertWorkflowInstance(processedInstance);
        if (id == -1L && StringUtils.hasText((String)instance.externalId)) {
            QueryWorkflowInstances query = new QueryWorkflowInstances.Builder().addTypes(instance.type).setExternalId(instance.externalId).build();
            id = this.workflowInstanceDao.queryWorkflowInstances((QueryWorkflowInstances)query).get((int)0).id;
        }
        return id;
    }

    @Transactional
    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="NflowNotFoundException message is ok")
    public boolean updateWorkflowInstance(WorkflowInstance instance, WorkflowInstanceAction action) {
        Assert.notNull((Object)instance, (String)"Workflow instance can not be null");
        Assert.notNull((Object)action, (String)"Workflow instance action can not be null");
        Assert.notNull((Object)this.workflowDefinitionService, (String)"workflowDefinitionService can not be null");
        try {
            WorkflowInstance.Builder builder = new WorkflowInstance.Builder(instance);
            if (instance.state == null) {
                builder.setStatus(null);
            } else {
                String type = this.workflowInstanceDao.getWorkflowInstanceType(instance.id);
                WorkflowDefinition definition = this.workflowDefinitionService.getWorkflowDefinition(type);
                builder.setStatus(definition.getState(instance.state).getType().getStatus(instance.nextActivation));
            }
            WorkflowInstance updatedInstance = builder.build();
            boolean updated = this.workflowInstanceDao.updateNotRunningWorkflowInstance(updatedInstance);
            if (updated) {
                String currentState = this.workflowInstanceDao.getWorkflowInstanceState(updatedInstance.id);
                WorkflowInstanceAction updatedAction = new WorkflowInstanceAction.Builder(action).setState(currentState).build();
                this.workflowInstanceDao.insertWorkflowInstanceAction(updatedInstance, updatedAction);
            } else {
                this.workflowInstanceDao.getWorkflowInstance(instance.id, Collections.emptySet(), 0L, false);
            }
            return updated;
        }
        catch (EmptyResultDataAccessException e) {
            throw new NflowNotFoundException("Workflow instance", instance.id, e);
        }
    }

    @Transactional
    public boolean wakeupWorkflowInstance(long id, List<String> expectedStates) {
        return this.workflowInstanceDao.wakeupWorkflowInstanceIfNotExecuting(id, expectedStates);
    }

    public Collection<WorkflowInstance> listWorkflowInstances(QueryWorkflowInstances query) {
        return this.workflowInstanceDao.queryWorkflowInstances(query);
    }

    public Stream<WorkflowInstance> listWorkflowInstancesAsStream(QueryWorkflowInstances query) {
        return this.workflowInstanceDao.queryWorkflowInstancesAsStream(query);
    }

    public Optional<Integer> getSignal(long workflowInstanceId) {
        return this.workflowInstanceDao.getSignal(workflowInstanceId);
    }

    public boolean setSignal(long workflowInstanceId, Optional<Integer> signal, String reason, WorkflowInstanceAction.WorkflowActionType actionType) {
        Assert.notNull((Object)this.workflowDefinitionService, (String)"workflowDefinitionService cannot be null");
        signal.ifPresent(signalValue -> {
            WorkflowDefinition definition = this.getDefinition(workflowInstanceId);
            if (!definition.getSupportedSignals().containsKey(signalValue)) {
                logger.warn("Setting unsupported signal value {} to instance {}.", signalValue, (Object)workflowInstanceId);
            }
        });
        return this.workflowInstanceDao.setSignal(workflowInstanceId, signal, reason, actionType);
    }

    private WorkflowDefinition getDefinition(Long workflowInstanceId) {
        return this.workflowDefinitionService.getWorkflowDefinition(this.workflowInstanceDao.getWorkflowInstanceType(workflowInstanceId));
    }

    public boolean hasUnfinishedChildWorkflows(long workflowInstanceId) {
        QueryWorkflowInstances unfinishedChildren = new QueryWorkflowInstances.Builder().addStatuses(UNFINISHED_STATUSES).setParentWorkflowId(workflowInstanceId).build();
        return !this.listWorkflowInstances(unfinishedChildren).isEmpty();
    }
}

