/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.definition;

import io.nflow.engine.internal.workflow.WorkflowDefinitionScanner;
import io.nflow.engine.internal.workflow.WorkflowStateMethod;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class WorkflowDefinition
extends ModelObject {
    private final String type;
    private String name;
    private String description;
    private final WorkflowState initialState;
    private final WorkflowState errorState;
    private final WorkflowSettings settings;
    protected final Map<String, List<String>> allowedTransitions = new LinkedHashMap<String, List<String>>();
    protected final Map<String, WorkflowState> failureTransitions = new LinkedHashMap<String, WorkflowState>();
    private Map<String, WorkflowStateMethod> stateMethods;
    private final Set<WorkflowState> states = new HashSet<WorkflowState>();
    private final boolean verifyStateMethodValidity;

    protected WorkflowDefinition(String type, WorkflowState initialState, WorkflowState errorState) {
        this(type, initialState, errorState, new WorkflowSettings.Builder().build());
    }

    protected WorkflowDefinition(String type, WorkflowState initialState, WorkflowState errorState, WorkflowSettings settings) {
        this(type, initialState, errorState, settings, null);
    }

    protected WorkflowDefinition(String type, WorkflowState initialState, WorkflowState errorState, WorkflowSettings settings, Map<String, WorkflowStateMethod> stateMethods) {
        this(type, initialState, errorState, settings, stateMethods, null, true);
    }

    protected WorkflowDefinition(String type, WorkflowState initialState, WorkflowState errorState, WorkflowSettings settings, Map<String, WorkflowStateMethod> stateMethods, Collection<WorkflowState> states) {
        this(type, initialState, errorState, settings, stateMethods, states, true);
    }

    protected WorkflowDefinition(String type, WorkflowState initialState, WorkflowState errorState, WorkflowSettings settings, Map<String, WorkflowStateMethod> stateMethods, Collection<WorkflowState> states, boolean verifyStateMethodValidity) {
        Assert.notNull((Object)initialState, (String)"initialState must not be null");
        Assert.isTrue((initialState.getType() == WorkflowStateType.start ? 1 : 0) != 0, (String)"initialState must be a start state");
        Assert.notNull((Object)errorState, (String)"errorState must not be null");
        this.type = type;
        this.initialState = initialState;
        this.errorState = errorState;
        this.settings = settings;
        this.verifyStateMethodValidity = verifyStateMethodValidity;
        WorkflowDefinitionScanner scanner = new WorkflowDefinitionScanner();
        if (stateMethods == null) {
            Assert.isTrue((boolean)verifyStateMethodValidity, (String)"State method validity verification must be enabled when given state methods are null (scanned from classpath)");
            this.stateMethods = scanner.getStateMethods(this.getClass());
        } else {
            if (!verifyStateMethodValidity) {
                Assert.isTrue((boolean)stateMethods.isEmpty(), (String)"State method validity verification must be enabled when given state methods is not empty");
            }
            this.stateMethods = stateMethods;
        }
        this.registerState(initialState);
        this.registerState(errorState);
        if (states == null) {
            scanner.getPublicStaticWorkflowStates(this.getClass()).forEach(this::registerState);
        } else {
            states.forEach(this::registerState);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public WorkflowState getInitialState() {
        return this.initialState;
    }

    public WorkflowState getErrorState() {
        return this.errorState;
    }

    public Set<WorkflowState> getStates() {
        return new HashSet<WorkflowState>(this.states);
    }

    public final void registerState(WorkflowState state) {
        this.requireStateMethodExists(state);
        this.states.add(state);
    }

    public Map<String, List<String>> getAllowedTransitions() {
        return new LinkedHashMap<String, List<String>>(this.allowedTransitions);
    }

    public Map<String, WorkflowState> getFailureTransitions() {
        return new LinkedHashMap<String, WorkflowState>(this.failureTransitions);
    }

    protected WorkflowDefinition permit(WorkflowState originState, WorkflowState targetState) {
        this.registerState(originState);
        this.registerState(targetState);
        this.allowedTransitionsFor(originState).add(targetState.name());
        return this;
    }

    protected WorkflowDefinition permit(WorkflowState originState, WorkflowState targetState, WorkflowState failureState) {
        Assert.notNull((Object)failureState, (String)"Failure state can not be null");
        this.registerState(failureState);
        WorkflowState existingFailure = this.failureTransitions.put(originState.name(), failureState);
        if (existingFailure != null) {
            Assert.isTrue((boolean)existingFailure.equals(failureState), (String)("Different failureState '" + existingFailure.name() + "' already defined for originState '" + originState.name() + "'"));
        }
        return this.permit(originState, targetState);
    }

    private List<String> allowedTransitionsFor(WorkflowState state) {
        String stateName = state.name();
        List<String> transitions = this.allowedTransitions.get(stateName);
        if (transitions == null) {
            transitions = new ArrayList<String>();
            this.allowedTransitions.put(stateName, transitions);
        }
        return transitions;
    }

    public WorkflowSettings getSettings() {
        return this.settings;
    }

    final void requireStateMethodExists(WorkflowState state) {
        if (!this.verifyStateMethodValidity) {
            return;
        }
        WorkflowStateMethod stateMethod = this.stateMethods.get(state.name());
        if (stateMethod == null && !state.getType().isFinal()) {
            String msg = String.format("Class '%s' is missing non-final state handling method 'public NextAction %s(StateExecution execution, ... args)'", this.getClass().getName(), state.name());
            throw new IllegalArgumentException(msg);
        }
        if (stateMethod != null) {
            WorkflowStateType stateType = state.getType();
            Class<?> returnType = stateMethod.method.getReturnType();
            if (!stateType.isFinal() && !NextAction.class.equals(returnType)) {
                String msg = String.format("Class '%s' has a non-final state method '%s' that does not return NextAction", this.getClass().getName(), state.name());
                throw new IllegalArgumentException(msg);
            }
            if (stateType.isFinal() && !Void.TYPE.equals(returnType)) {
                String msg = String.format("Class '%s' has a final state method '%s' that returns a value", this.getClass().getName(), state.name());
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public WorkflowStateMethod getMethod(String stateName) {
        return this.stateMethods.get(stateName);
    }

    public WorkflowStateMethod getMethod(WorkflowState state) {
        return this.stateMethods.get(state.name());
    }

    public WorkflowState getState(String state) {
        return this.getStates().stream().filter(s -> Objects.equals(s.name(), state)).findFirst().orElseThrow(() -> new IllegalArgumentException("No state '" + state + "' in workflow definiton " + this.getType()));
    }

    public boolean isStartState(String state) {
        return this.getState(state).getType() == WorkflowStateType.start;
    }

    public boolean isAllowedNextAction(WorkflowInstance instance, NextAction nextAction) {
        if (nextAction.isRetry()) {
            return true;
        }
        List<String> allowedNextStates = this.allowedTransitions.get(instance.state);
        if (allowedNextStates != null && allowedNextStates.contains(nextAction.getNextState().name())) {
            return true;
        }
        if (nextAction.getNextState() == this.failureTransitions.get(instance.state)) {
            return true;
        }
        return nextAction.getNextState() == this.getErrorState();
    }

    public Map<Integer, String> getSupportedSignals() {
        return Collections.emptyMap();
    }
}

