/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.definition;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.exception.StateProcessExceptionHandling;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.definition.NonRetryable;
import io.nflow.engine.workflow.definition.WorkflowState;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="used by nflow-rest")
public class WorkflowSettings
extends ModelObject {
    private static final BiFunction<WorkflowState, Throwable, StateProcessExceptionHandling> DEFAULT_EXCEPTION_ANALYZER = (state, thrown) -> new StateProcessExceptionHandling.Builder().setRetryable(!thrown.getClass().isAnnotationPresent(NonRetryable.class)).build();
    private static final Logger logger = LoggerFactory.getLogger(WorkflowSettings.class);
    public final long minErrorTransitionDelay;
    public final long maxErrorTransitionDelay;
    public final long shortTransitionDelay;
    public final int maxRetries;
    public final int maxSubsequentStateExecutions;
    public final Map<WorkflowState, Integer> maxSubsequentStateExecutionsPerState;
    public final ReadablePeriod historyDeletableAfter;
    public final BooleanSupplier deleteHistoryCondition;
    public final short defaultPriority;
    private final BiFunction<WorkflowState, Throwable, StateProcessExceptionHandling> exceptionAnalyzer;

    WorkflowSettings(Builder builder) {
        this.minErrorTransitionDelay = builder.minErrorTransitionDelay.getMillis();
        this.maxErrorTransitionDelay = builder.maxErrorTransitionDelay.getMillis();
        this.shortTransitionDelay = builder.shortTransitionDelay.getMillis();
        this.maxRetries = builder.maxRetries;
        this.maxSubsequentStateExecutions = builder.maxSubsequentStateExecutions;
        this.maxSubsequentStateExecutionsPerState = new HashMap<WorkflowState, Integer>(builder.maxSubsequentStateExecutionsPerState);
        this.historyDeletableAfter = builder.historyDeletableAfter;
        this.deleteHistoryCondition = builder.deleteHistoryCondition;
        this.defaultPriority = builder.defaultPriority;
        this.exceptionAnalyzer = builder.exceptionAnalyzer;
    }

    public DateTime getErrorTransitionActivation(int retryCount) {
        return DateTime.now().plus(this.calculateBinaryBackoffDelay(retryCount + 1, this.minErrorTransitionDelay, this.maxErrorTransitionDelay));
    }

    protected long calculateBinaryBackoffDelay(int retryCount, long minDelay, long maxDelay) {
        BigInteger delay = BigInteger.valueOf(minDelay).multiply(BigInteger.valueOf(2L).pow(retryCount));
        try {
            return Math.max(minDelay, Math.min(delay.longValueExact(), maxDelay));
        }
        catch (ArithmeticException overflow) {
            return maxDelay;
        }
    }

    public DateTime getShortTransitionActivation() {
        return DateTime.now().plus((ReadableDuration)Duration.millis((long)this.shortTransitionDelay));
    }

    public int getMaxSubsequentStateExecutions(WorkflowState state) {
        return this.maxSubsequentStateExecutionsPerState.getOrDefault(state, this.maxSubsequentStateExecutions);
    }

    public boolean deleteWorkflowInstanceHistory() {
        return this.deleteHistoryCondition.getAsBoolean();
    }

    public Short getDefaultPriority() {
        return this.defaultPriority;
    }

    public StateProcessExceptionHandling analyzeExeption(WorkflowState state, Throwable thrown) {
        if (this.exceptionAnalyzer != null) {
            try {
                return this.exceptionAnalyzer.apply(state, thrown);
            }
            catch (Exception e) {
                logger.error("Custom exception analysis failed, using default analyzer.", (Throwable)e);
            }
        }
        return DEFAULT_EXCEPTION_ANALYZER.apply(state, thrown);
    }

    public static class Builder {
        ReadableDuration maxErrorTransitionDelay = Duration.standardDays((long)1L);
        ReadableDuration minErrorTransitionDelay = Duration.standardMinutes((long)1L);
        ReadableDuration shortTransitionDelay = Duration.standardSeconds((long)30L);
        int maxRetries = 17;
        int maxSubsequentStateExecutions = 100;
        Map<WorkflowState, Integer> maxSubsequentStateExecutionsPerState = new HashMap<WorkflowState, Integer>();
        ReadablePeriod historyDeletableAfter = Period.days((int)45);
        short defaultPriority = 0;
        BooleanSupplier deleteHistoryCondition = Builder.onAverageEveryNthExecution(100);
        BiFunction<WorkflowState, Throwable, StateProcessExceptionHandling> exceptionAnalyzer;

        @SuppressFBWarnings(value={"MDM_RANDOM_SEED"}, justification="Random does not need to be secure here")
        public static BooleanSupplier onAverageEveryNthExecution(int n) {
            return () -> ThreadLocalRandom.current().nextInt(n) == 0;
        }

        public static BooleanSupplier oncePerDay() {
            AtomicLong nextExecution = new AtomicLong(LocalDateTime.now().plusDays(1).withHourOfDay(4).toDateTime().getMillis());
            return () -> {
                long next;
                long now = DateTimeUtils.currentTimeMillis();
                if (now > (next = nextExecution.get())) {
                    nextExecution.set(next + Duration.standardDays((long)1L).getMillis());
                    return true;
                }
                return false;
            };
        }

        public Builder setMaxErrorTransitionDelay(Duration maxErrorTransitionDelay) {
            this.maxErrorTransitionDelay = maxErrorTransitionDelay;
            return this;
        }

        public Builder setMinErrorTransitionDelay(Duration minErrorTransitionDelay) {
            this.minErrorTransitionDelay = minErrorTransitionDelay;
            return this;
        }

        public Builder setShortTransitionDelay(Duration shortTransitionDelay) {
            this.shortTransitionDelay = shortTransitionDelay;
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setMaxSubsequentStateExecutions(int maxSubsequentStateExecutions) {
            this.maxSubsequentStateExecutions = maxSubsequentStateExecutions;
            return this;
        }

        public Builder setMaxSubsequentStateExecutions(WorkflowState state, int maxSubsequentStateExecutions) {
            this.maxSubsequentStateExecutionsPerState.put(state, maxSubsequentStateExecutions);
            return this;
        }

        public Builder setHistoryDeletableAfter(ReadablePeriod period) {
            this.historyDeletableAfter = period;
            return this;
        }

        public Builder setDeleteHistoryCondition(BooleanSupplier deleteHistoryCondition) {
            this.deleteHistoryCondition = deleteHistoryCondition;
            return this;
        }

        public Builder setDefaultPriority(short defaultPriority) {
            this.defaultPriority = defaultPriority;
            return this;
        }

        public Builder setExceptionAnalyzer(BiFunction<WorkflowState, Throwable, StateProcessExceptionHandling> exceptionAnalyzer) {
            this.exceptionAnalyzer = exceptionAnalyzer;
            return this;
        }

        public WorkflowSettings build() {
            return new WorkflowSettings(this);
        }
    }
}

