/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth;

import io.phasetwo.keycloak.magic.MagicLink;
import io.phasetwo.keycloak.magic.auth.token.MagicLinkContinuationActionToken;
import io.phasetwo.keycloak.magic.auth.util.Authenticators;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.time.ZonedDateTime;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.browser.UsernamePasswordForm;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.utils.StringUtil;

public class MagicLinkContinuationAuthenticator
extends UsernamePasswordForm {
    private static final Logger log = Logger.getLogger(MagicLinkContinuationAuthenticator.class);

    public void authenticate(AuthenticationFlowContext context) {
        log.debug((Object)"MagicLinkContinuationAuthenticator.authenticate");
        if (this.sessionExpired(context)) {
            AuthenticationSessionManager manager = new AuthenticationSessionManager(context.getSession());
            manager.removeTabIdInAuthenticationSession(context.getRealm(), context.getAuthenticationSession());
            context.getEvent().error("session_expired");
            Response challengeResponse = this.challenge(context, "expiredActionTokenNoSessionMessage", "username");
            context.failureChallenge(AuthenticationFlowError.GENERIC_AUTHENTICATION_ERROR, challengeResponse);
            return;
        }
        String attemptedUsername = MagicLink.getAttemptedUsername(context);
        String sessionConfirmed = context.getAuthenticationSession().getAuthNote("SESSION_CONFIRMED");
        if (StringUtil.isNotBlank((String)sessionConfirmed)) {
            UserModel user = MagicLink.isValidEmail(attemptedUsername) ? context.getSession().users().getUserByEmail(context.getRealm(), attemptedUsername) : context.getSession().users().getUserByUsername(context.getRealm(), attemptedUsername);
            context.setUser(user);
            context.getAuthenticationSession().setAuthenticatedUser(user);
            context.success();
        } else if (attemptedUsername == null) {
            super.authenticate(context);
        } else {
            String sessionInitiated = context.getAuthenticationSession().getAuthNote("SESSION_INITIATED");
            if (StringUtil.isBlank((String)sessionInitiated)) {
                log.debugf("Found attempted username %s from previous authenticator, skipping login form", (Object)attemptedUsername);
                this.action(context);
            } else {
                context.challenge(context.form().createForm("view-email-continuation.ftl"));
            }
        }
    }

    private boolean sessionExpired(AuthenticationFlowContext context) {
        String expiration = context.getAuthenticationSession().getAuthNote("SESSION_EXPIRATION");
        if (StringUtil.isNotBlank((String)expiration)) {
            ZonedDateTime expirationTime = ZonedDateTime.parse(expiration);
            return expirationTime.isBefore(ZonedDateTime.now());
        }
        return false;
    }

    public void action(AuthenticationFlowContext context) {
        log.debug((Object)"MagicLinkAuthenticator.action");
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String email = MagicLink.trimToNull((String)formData.getFirst((Object)"username"));
        if (email == null) {
            email = MagicLink.getAttemptedUsername(context);
        }
        log.debugf("email in action is %s", (Object)email);
        if (email == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        String clientId = context.getSession().getContext().getClient().getClientId();
        EventBuilder event = context.newEvent();
        UserModel user = MagicLink.getOrCreate(context.getSession(), context.getRealm(), email, this.isForceCreate(context, false), false, false, MagicLink.registerEvent(event));
        if (user == null || MagicLink.trimToNull(user.getEmail()) == null || !MagicLink.isValidEmail(user.getEmail())) {
            context.getEvent().event(EventType.LOGIN_ERROR).error("invalid_email");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        log.debugf("user is %s %s", (Object)user.getEmail(), (Object)user.isEnabled());
        if (!this.enabledUser(context, user)) {
            return;
        }
        int timeout = this.getTimeout(context, 10);
        int validityInSecs = 60 * timeout;
        MagicLinkContinuationActionToken token = MagicLink.createExpandedActionToken(user, clientId, validityInSecs, context.getAuthenticationSession());
        String link = MagicLink.linkFromActionToken(context.getSession(), context.getRealm(), token);
        boolean sent = MagicLink.sendMagicLinkContinuationEmail(context.getSession(), user, link);
        log.debugf("sent email to %s? %b. Link? %s", (Object)user.getEmail(), (Object)sent, (Object)link);
        context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", email);
        context.getAuthenticationSession().setAuthNote("SESSION_INITIATED", "true");
        String sessionExpiration = ZonedDateTime.now().plusMinutes(timeout).plusSeconds(2L).toString();
        context.getAuthenticationSession().setAuthNote("SESSION_EXPIRATION", sessionExpiration);
        context.challenge(context.form().createForm("view-email-continuation.ftl"));
    }

    private boolean isForceCreate(AuthenticationFlowContext context, boolean defaultValue) {
        return Authenticators.is(context, "ext-magic-create-nonexistent-user", defaultValue);
    }

    protected boolean validateForm(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        log.debug((Object)"validateForm");
        return this.validateUser(context, formData);
    }

    protected Response challenge(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        log.debug((Object)"challenge");
        LoginFormsProvider forms = context.form();
        if (!formData.isEmpty()) {
            forms.setFormData(formData);
        }
        return forms.createLoginUsername();
    }

    protected Response createLoginForm(LoginFormsProvider form) {
        log.debug((Object)"createLoginForm");
        return form.createLoginUsername();
    }

    protected String getDefaultChallengeMessage(AuthenticationFlowContext context) {
        log.debug((Object)"getDefaultChallengeMessage");
        return context.getRealm().isLoginWithEmailAllowed() ? "invalidUsernameOrEmailMessage" : "invalidUsernameMessage";
    }

    private int getTimeout(AuthenticationFlowContext context, int defaultValue) {
        AuthenticatorConfigModel authenticatorConfig = context.getAuthenticatorConfig();
        if (authenticatorConfig == null) {
            return defaultValue;
        }
        Map config = authenticatorConfig.getConfig();
        if (config == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt((String)config.get("TIMEOUT"));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

