/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.resources;

import io.phasetwo.keycloak.magic.MagicLink;
import io.phasetwo.keycloak.magic.auth.token.MagicLinkActionToken;
import io.phasetwo.keycloak.magic.representation.MagicLinkRequest;
import io.phasetwo.keycloak.magic.representation.MagicLinkResponse;
import io.phasetwo.keycloak.magic.resources.AbstractAdminResource;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class MagicLinkResource
extends AbstractAdminResource {
    private static final Logger log = Logger.getLogger(MagicLinkResource.class);

    public MagicLinkResource(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public MagicLinkResponse createMagicLink(MagicLinkRequest rep) {
        UserModel user;
        if (!this.permissions.users().canManage()) {
            throw new ForbiddenException("magic link requires manage-users");
        }
        ClientModel client = this.session.clients().getClientByClientId(this.realm, rep.getClientId());
        if (client == null) {
            throw new NotFoundException(String.format("Client with ID %s not found.", rep.getClientId()));
        }
        if (!MagicLink.validateRedirectUri(this.session, rep.getRedirectUri(), client)) {
            throw new BadRequestException(String.format("redirectUri %s disallowed by client.", rep.getRedirectUri()));
        }
        String emailOrUsername = rep.getEmail();
        boolean forceCreate = rep.isForceCreate();
        boolean updateProfile = rep.isUpdateProfile();
        boolean updatePassword = rep.isUpdatePassword();
        boolean sendEmail = rep.isSendEmail();
        if (rep.getUsername() != null) {
            emailOrUsername = rep.getUsername();
            forceCreate = false;
            sendEmail = false;
        }
        if ((user = MagicLink.getOrCreate(this.session, this.realm, emailOrUsername, forceCreate, updateProfile, updatePassword, MagicLink.registerEvent(this.event))) == null) {
            throw new NotFoundException(String.format("User with email/username %s not found, and forceCreate is off.", emailOrUsername));
        }
        MagicLinkActionToken token = MagicLink.createActionToken(user, rep.getClientId(), rep.getRedirectUri(), OptionalInt.of(rep.getExpirationSeconds()), rep.getScope(), rep.getNonce(), rep.getState(), rep.getRememberMe(), rep.getActionTokenPersistent());
        String link = MagicLink.linkFromActionToken(this.session, this.realm, token);
        boolean sent = false;
        if (sendEmail) {
            sent = MagicLink.sendMagicLinkEmail(this.session, user, link);
            log.infof("sent email to %s? %b. Link? %s", (Object)rep.getEmail(), (Object)sent, (Object)link);
        }
        MagicLinkResponse resp = new MagicLinkResponse();
        resp.setUserId(user.getId());
        resp.setLink(link);
        resp.setSent(sent);
        return resp;
    }
}

