/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.URI;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.Assert;
import reactor.fn.Supplier;
import reactor.fn.tuple.Tuple2;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.Reconnect;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.config.SslOptions;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.http.HttpClient;
import reactor.io.net.http.model.Method;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.http.NettyHttpChannel;
import reactor.io.net.impl.netty.http.NettyHttpClientHandler;
import reactor.io.net.impl.netty.http.NettyHttpWSClientHandler;
import reactor.io.net.impl.netty.tcp.NettyTcpClient;
import reactor.rx.Promise;
import reactor.rx.Promises;
import reactor.rx.Stream;
import reactor.rx.Streams;

public class NettyHttpClient<IN, OUT>
extends HttpClient<IN, OUT> {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClient.class);
    private final NettyTcpClient<IN, OUT> client;
    private final Promise<NettyHttpChannel<IN, OUT>> reply;
    private URI lastURI = null;

    public NettyHttpClient(Environment env, Dispatcher dispatcher, Supplier<InetSocketAddress> connectAddress, ClientSocketOptions options, SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec, options);
        Supplier<InetSocketAddress> _connectAddress = connectAddress == null ? new Supplier<InetSocketAddress>(){

            public InetSocketAddress get() {
                try {
                    int port;
                    URI url = NettyHttpClient.this.lastURI;
                    String host = url != null && url.getHost() != null ? url.getHost() : "localhost";
                    int n = port = url != null ? url.getPort() : -1;
                    if (port == -1) {
                        port = url != null && url.getScheme() != null && (url.getScheme().toLowerCase().equals("https") || url.getScheme().toLowerCase().equals("wss")) ? 443 : 80;
                    }
                    return new InetSocketAddress(host, port);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } : connectAddress;
        this.client = new NettyTcpClient<IN, OUT>(env, dispatcher, (Supplier)_connectAddress, options, sslOptions, codec){

            @Override
            protected void bindChannel(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, SocketChannel nativeChannel) {
                URI currentURI = NettyHttpClient.this.lastURI;
                try {
                    if (currentURI.getScheme() != null && (currentURI.getScheme().toLowerCase().equals("https") || currentURI.getScheme().toLowerCase().equals("wss"))) {
                        this.addSecureHandler(nativeChannel);
                    }
                }
                catch (Exception e) {
                    nativeChannel.pipeline().fireExceptionCaught((Throwable)e);
                }
                NettyHttpClient.this.bindChannel(handler, nativeChannel);
            }
        };
        this.reply = Promises.prepare();
    }

    @Override
    protected Promise<Void> doStart(final ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        return this.client.start(new ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>>(){

            public Publisher<Void> apply(ChannelStream<IN, OUT> inoutChannelStream) {
                NettyHttpChannel ch = (NettyHttpChannel)inoutChannelStream;
                return (Publisher)handler.apply(ch);
            }
        });
    }

    @Override
    protected Stream<Tuple2<InetSocketAddress, Integer>> doStart(final ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler, Reconnect reconnect) {
        return this.client.start(new ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>>(){

            public Publisher<Void> apply(ChannelStream<IN, OUT> inoutChannelStream) {
                NettyHttpChannel ch = (NettyHttpChannel)inoutChannelStream;
                return (Publisher)handler.apply(ch);
            }
        }, reconnect);
    }

    @Override
    public Promise<? extends HttpChannel<IN, OUT>> request(final Method method, String url, final ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        URI currentURI;
        try {
            Assert.isTrue((method != null && url != null ? 1 : 0) != 0);
            this.lastURI = currentURI = this.parseURL(method, url);
        }
        catch (Exception e) {
            return Promises.error((Throwable)e);
        }
        this.start(new ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>>(){

            public Publisher<Void> apply(HttpChannel<IN, OUT> inoutHttpChannel) {
                try {
                    NettyHttpChannel ch = (NettyHttpChannel)inoutHttpChannel;
                    ch.getNettyRequest().setUri(currentURI.getPath() + (currentURI.getQuery() == null ? "" : "?" + currentURI.getQuery())).setMethod(new HttpMethod(method.getName())).headers().add("Host", (Object)currentURI.getHost()).add("Accept", (Object)"*/*");
                    if (handler != null) {
                        Publisher p = (Publisher)handler.apply(ch);
                        NettyHttpClient.this.reply.onNext((Object)ch);
                        return p;
                    }
                    NettyHttpClient.this.reply.onNext((Object)ch);
                    return Streams.empty();
                }
                catch (Throwable t) {
                    NettyHttpClient.this.reply.onError(t);
                    return Promises.error((Throwable)t);
                }
            }
        });
        return this.reply;
    }

    private URI parseURL(Method method, String url) throws Exception {
        if (!url.startsWith("http") && !url.startsWith("ws")) {
            String parsedUrl = (method.equals(Method.WS) ? "ws" : "http") + "://";
            if (url.startsWith("/")) {
                return new URI(parsedUrl + (this.lastURI != null && this.lastURI.getHost() != null ? this.lastURI.getHost() : "localhost") + url);
            }
            return new URI(parsedUrl + url);
        }
        return new URI(url);
    }

    @Override
    protected final Promise<Void> doShutdown() {
        return this.client.shutdown();
    }

    protected void bindChannel(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, Object nativeChannel) {
        SocketChannel ch = (SocketChannel)nativeChannel;
        NettyChannelStream netChannel = new NettyChannelStream(this.getDefaultEnvironment(), this.getDefaultCodec(), this.getDefaultPrefetchSize(), this.getDefaultDispatcher(), (Channel)ch);
        ChannelPipeline pipeline = ch.pipeline();
        if (log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(NettyHttpClient.class)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        URI currentURI = this.lastURI;
        if (currentURI.getScheme() != null && currentURI.getScheme().toLowerCase().startsWith("ws")) {
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)}).addLast(new ChannelHandler[]{new NettyHttpWSClientHandler<IN, OUT>(handler, netChannel, WebSocketClientHandshakerFactory.newHandshaker((URI)this.lastURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()))});
        } else {
            pipeline.addLast(new ChannelHandler[]{new NettyHttpClientHandler<IN, OUT>(handler, netChannel)});
        }
    }
}

