/*
 * Decompiled with CFR 0.152.
 */
package io.provis.provision;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import io.provis.model.ArtifactSet;
import io.provis.model.Directory;
import io.provis.model.FileSet;
import io.provis.model.Lookup;
import io.provis.model.ProvisioArtifact;
import io.provis.model.ProvisioningAction;
import io.provis.model.ProvisioningContext;
import io.provis.model.ProvisioningRequest;
import io.provis.model.ProvisioningResult;
import io.provis.model.Resource;
import io.provis.model.ResourceSet;
import io.provis.model.Runtime;
import io.provis.provision.MavenProvisioner;
import io.provis.provision.ProvisioningException;
import io.provis.provision.action.artifact.WriteToDiskAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;

public class DefaultMavenProvisioner
implements MavenProvisioner {
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    private List<RemoteRepository> remoteRepositories;
    static Joiner joiner = Joiner.on((char)',').skipNulls();
    Lookup lookup = new Lookup();

    public DefaultMavenProvisioner(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
    }

    @Override
    public ProvisioningResult provision(ProvisioningRequest request) throws Exception {
        ProvisioningResult result = new ProvisioningResult();
        ProvisioningContext context = new ProvisioningContext(request, result);
        this.processArtifactSets(context);
        this.processResourceSets(context);
        this.processFileSets(context);
        this.processRuntimeActions(context);
        return result;
    }

    private void processArtifactSets(ProvisioningContext context) throws Exception {
        for (ArtifactSet artifactSet : context.getRequest().getRuntimeModel().getArtifactSets()) {
            this.processArtifactSet(context, artifactSet);
        }
    }

    private void processArtifactSet(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
        this.resolveArtifactSetOutputDirectory(context, artifactSet);
        this.resolveArtifactSet(context, artifactSet);
        this.processArtifactsWithActions(context, artifactSet);
        this.processArtifactSetActions(context, artifactSet);
        if (artifactSet.getArtifactSets() != null) {
            for (ArtifactSet childFileSet : artifactSet.getArtifactSets()) {
                this.processArtifactSet(context, childFileSet);
            }
        }
    }

    private void resolveArtifactSetOutputDirectory(ProvisioningContext context, ArtifactSet artifactSet) {
        ArtifactSet parent = artifactSet.getParent();
        if (parent != null) {
            artifactSet.setOutputDirectory(new File(parent.getOutputDirectory(), artifactSet.getDirectory()));
        } else if (artifactSet.getDirectory().equals("root") || artifactSet.getDirectory().equals("/")) {
            artifactSet.setOutputDirectory(context.getRequest().getOutputDirectory());
        } else {
            artifactSet.setOutputDirectory(new File(context.getRequest().getOutputDirectory(), artifactSet.getDirectory()));
        }
        if (!artifactSet.getOutputDirectory().exists()) {
            artifactSet.getOutputDirectory().mkdirs();
        }
    }

    private void processArtifactSetActions(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
    }

    private void processArtifactsWithActions(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
        for (ProvisioArtifact artifact : artifactSet.getResolvedArtifacts()) {
            if (artifact.getActions() != null) {
                for (ProvisioningAction action : artifact.getActions()) {
                    this.configureArtifactAction(artifact, action, artifactSet.getOutputDirectory());
                    action.execute(context);
                }
                continue;
            }
            WriteToDiskAction action = new WriteToDiskAction((Artifact)artifact, artifactSet.getOutputDirectory());
            action.execute(context);
        }
    }

    public Set<ProvisioArtifact> resolveArtifactSet(ProvisioningContext context, ArtifactSet artifactSet) {
        List<Artifact> resultArtifacts;
        List artifacts;
        CollectRequest request = new CollectRequest();
        if (artifactSet.getReference() != null) {
            Runtime runtime = context.getRequest().getRuntimeModel();
            if (runtime.getArtifactSetReferences() == null) {
                throw new RuntimeException(String.format("The reference '%s' is being requested but the artifactSet references are null.", artifactSet.getReference()));
            }
            ArtifactSet referenceArtifactSet = (ArtifactSet)runtime.getArtifactSetReferences().get(artifactSet.getReference());
            if (referenceArtifactSet == null) {
                throw new RuntimeException(String.format("The is no '%s' artifactSet reference available.", artifactSet.getReference()));
            }
            artifacts = referenceArtifactSet.getArtifacts();
        } else {
            artifacts = artifactSet.getArtifacts();
        }
        ArrayList providedArtifacts = Lists.newArrayList();
        for (ProvisioArtifact artifact : artifacts) {
            if (artifact.getFile() != null) {
                providedArtifacts.add(artifact);
                continue;
            }
            DefaultArtifactType type = null;
            if (artifact.getExtension().equals("tar.gz")) {
                type = new DefaultArtifactType("tar.gz", "tar.gz", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("zip")) {
                type = new DefaultArtifactType("zip", "zip", "", "packaging", false, true);
            }
            if (this.getArtifactType(artifact.getExtension()) == null) {
                type = new DefaultArtifactType(artifact.getExtension(), artifact.getExtension(), "", "unknown", false, true);
            }
            if (type != null) {
                artifact.setProperties(type.getProperties());
            }
            Dependency dependency = new Dependency((Artifact)artifact, "runtime");
            request.addDependency(dependency);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(request, null);
        if (artifactSet.getExcludes() != null) {
            dependencyRequest.setFilter((DependencyFilter)new ExclusionsDependencyFilter((Collection)artifactSet.getExcludes()));
        }
        for (String coordinate : context.getRequest().getManagedDependencies()) {
            ProvisioArtifact artifact = new ProvisioArtifact(coordinate);
            request.addManagedDependency(new Dependency((Artifact)artifact, "runtime"));
        }
        if (artifactSet.getParent() != null && artifactSet.getParent().getResolvedArtifacts() != null) {
            for (Artifact artifact : artifactSet.getParent().getResolvedArtifacts()) {
                request.addManagedDependency(new Dependency(artifact, "runtime"));
            }
        }
        try {
            resultArtifacts = this.resolveArtifacts(dependencyRequest);
            resultArtifacts.addAll(providedArtifacts);
        }
        catch (DependencyResolutionException e) {
            throw new ProvisioningException(e.getMessage(), e);
        }
        HashMap<String, ProvisioArtifact> artifactMapKeyedByGa = new HashMap<String, ProvisioArtifact>();
        HashSet resolvedArtifacts = Sets.newHashSet();
        for (Artifact a : resultArtifacts) {
            String ga = a.getGroupId() + ":" + a.getArtifactId();
            if (a instanceof ProvisioArtifact) {
                artifactMapKeyedByGa.put(ga, (ProvisioArtifact)a);
                resolvedArtifacts.add((ProvisioArtifact)a);
                continue;
            }
            artifactMapKeyedByGa.put(ga, new ProvisioArtifact(a));
            resolvedArtifacts.add(new ProvisioArtifact(a));
        }
        artifactSet.setResolvedArtifacts((Set)resolvedArtifacts);
        ArtifactSet parent = artifactSet.getParent();
        if (parent != null) {
            Set parentArtifacts = artifactSet.getParent().getResolvedArtifacts();
            Sets.SetView childResolvedArtifacts = Sets.difference((Set)resolvedArtifacts, (Set)parentArtifacts);
            artifactSet.setResolvedArtifacts((Set)childResolvedArtifacts);
        } else {
            artifactSet.setResolvedArtifacts((Set)resolvedArtifacts);
        }
        return resolvedArtifacts;
    }

    public List<Artifact> resolveArtifacts(String coordinate) throws DependencyResolutionException {
        return this.resolveArtifacts((Artifact)new DefaultArtifact(coordinate));
    }

    public List<Artifact> resolveArtifacts(Artifact artifact) throws DependencyResolutionException {
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "runtime"));
        for (RemoteRepository remoteRepository : this.remoteRepositories) {
            collectRequest.addRepository(remoteRepository);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFlter);
        return this.resolveArtifacts(dependencyRequest);
    }

    public List<Artifact> resolveArtifacts(DependencyRequest request) throws DependencyResolutionException {
        CollectRequest collectRequest = request.getCollectRequest();
        if (collectRequest.getRepositories() == null || collectRequest.getRepositories().isEmpty()) {
            for (RemoteRepository remoteRepository : this.remoteRepositories) {
                collectRequest.addRepository(remoteRepository);
            }
        }
        DependencyResult result = this.repositorySystem.resolveDependencies(this.repositorySystemSession, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (ArtifactResult ar : result.getArtifactResults()) {
            artifacts.add(ar.getArtifact());
        }
        return artifacts;
    }

    public ArtifactType getArtifactType(String typeId) {
        return this.repositorySystemSession.getArtifactTypeRegistry().get(typeId);
    }

    private void processResourceSets(ProvisioningContext context) throws Exception {
        List resourceSets = context.getRequest().getRuntime().getResourceSets();
        if (resourceSets != null) {
            for (ResourceSet resourceSet : resourceSets) {
                for (Resource resource : resourceSet.getResources()) {
                    File source = new File(resource.getName());
                    if (!source.exists()) {
                        throw new RuntimeException(String.format("The specified file %s does not exist.", source));
                    }
                    File target = new File(context.getRequest().getOutputDirectory(), source.getName());
                    Files.copy((File)source, (File)target);
                }
            }
        }
    }

    private void processFileSets(ProvisioningContext context) throws Exception {
        List fileSets = context.getRequest().getRuntime().getFileSets();
        if (fileSets != null) {
            for (FileSet fileSet : fileSets) {
                for (io.provis.model.File file : fileSet.getFiles()) {
                    File source = new File(file.getPath());
                    if (!source.exists()) {
                        throw new RuntimeException(String.format("The specified file %s does not exist.", source));
                    }
                    File target = new File(context.getRequest().getOutputDirectory(), source.getName());
                    Files.copy((File)source, (File)target);
                }
                for (Directory directory : fileSet.getDirectories()) {
                    File sourceDirectory = new File(directory.getPath());
                    File targetDirectory = context.getRequest().getOutputDirectory();
                    this.copyDirectoryStructure(sourceDirectory, targetDirectory, directory.getIncludes(), directory.getExcludes());
                }
            }
        }
    }

    private void copyDirectoryStructure(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes) throws IOException {
        String includesString = null;
        if (includes != null && !includes.isEmpty()) {
            includesString = joiner.join(includes);
        }
        String excludesString = null;
        if (excludes != null && !excludes.isEmpty()) {
            excludesString = joiner.join(excludes);
        }
        List relativePaths = FileUtils.getFileNames((File)sourceDirectory, (String)includesString, excludesString, (boolean)false);
        for (String relativePath : relativePaths) {
            File source = new File(sourceDirectory, relativePath);
            File target = new File(targetDirectory, relativePath);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            Files.copy((File)source, (File)target);
        }
    }

    private void processRuntimeActions(ProvisioningContext context) throws Exception {
        List runtimeActions = context.getRequest().getRuntime().getActions();
        if (runtimeActions != null) {
            for (ProvisioningAction action : runtimeActions) {
                this.configureArtifactSetAction(action, context.getRequest().getOutputDirectory());
                action.execute(context);
            }
        }
    }

    private void configureArtifactSetAction(ProvisioningAction provisioningAction, File outputDirectory) {
        this.lookup.setObjectProperty((Object)provisioningAction, "fileSetDirectory", (Object)outputDirectory);
        this.lookup.setObjectProperty((Object)provisioningAction, "outputDirectory", (Object)outputDirectory);
        this.lookup.setObjectProperty((Object)provisioningAction, "runtimeDirectory", (Object)outputDirectory);
    }

    private void configureArtifactAction(ProvisioArtifact artifact, ProvisioningAction provisioningAction, File outputDirectory) {
        this.lookup.setObjectProperty((Object)provisioningAction, "artifact", (Object)artifact);
        this.lookup.setObjectProperty((Object)provisioningAction, "fileSetDirectory", (Object)outputDirectory);
        this.lookup.setObjectProperty((Object)provisioningAction, "outputDirectory", (Object)outputDirectory);
        this.lookup.setObjectProperty((Object)provisioningAction, "runtimeDirectory", (Object)outputDirectory);
    }
}

