/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.MultiBuildItem;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public final class AutoAddScopeBuildItem
extends MultiBuildItem {
    private final MatchPredicate matchPredicate;
    private final boolean containerServicesRequired;
    private final DotName defaultScope;
    private final boolean unremovable;
    private final String reason;
    private final int priority;
    private final BiConsumer<DotName, String> scopeAlreadyAdded;

    public static Builder builder() {
        return new Builder();
    }

    private AutoAddScopeBuildItem(MatchPredicate matchPredicate, boolean containerServicesRequired, DotName defaultScope, boolean unremovable, String reason, int priority, BiConsumer<DotName, String> scopeAlreadyAdded) {
        this.matchPredicate = matchPredicate;
        this.containerServicesRequired = containerServicesRequired;
        this.defaultScope = defaultScope;
        this.unremovable = unremovable;
        this.reason = reason;
        this.priority = priority;
        this.scopeAlreadyAdded = scopeAlreadyAdded;
    }

    public boolean isContainerServicesRequired() {
        return this.containerServicesRequired;
    }

    public DotName getDefaultScope() {
        return this.defaultScope;
    }

    public boolean isUnremovable() {
        return this.unremovable;
    }

    public String getReason() {
        return this.reason != null ? this.reason : "unknown";
    }

    public int getPriority() {
        return this.priority;
    }

    public BiConsumer<DotName, String> getScopeAlreadyAdded() {
        return this.scopeAlreadyAdded;
    }

    public boolean test(ClassInfo clazz, Collection<AnnotationInstance> annotations, IndexView index) {
        return this.matchPredicate.test(clazz, annotations, index);
    }

    public static class Builder {
        private MatchPredicate matchPredicate;
        private boolean requiresContainerServices = false;
        private DotName defaultScope = BuiltinScope.DEPENDENT.getName();
        private boolean unremovable = false;
        private String reason;
        private int priority = 0;
        private BiConsumer<DotName, String> scopeAlreadyAdded;

        private Builder() {
        }

        public Builder requiresContainerServices() {
            this.requiresContainerServices = true;
            return this;
        }

        public Builder unremovable() {
            this.unremovable = true;
            return this;
        }

        public Builder match(MatchPredicate predicate) {
            this.matchPredicate = predicate;
            return this;
        }

        public Builder isAnnotatedWith(DotName annotationName) {
            return this.and((clazz, annotations, index) -> Annotations.contains((Collection)annotations, (DotName)annotationName));
        }

        public Builder containsAnnotations(DotName ... annotationNames) {
            return this.and((clazz, annotations, index) -> {
                for (DotName annotation : annotationNames) {
                    if (!clazz.annotations().containsKey(annotation)) continue;
                    return true;
                }
                return false;
            });
        }

        public Builder implementsInterface(DotName interfaceName) {
            return this.and((clazz, annotations, index) -> {
                if (clazz.interfaceNames().contains(interfaceName)) {
                    return true;
                }
                DotName superName = clazz.superName();
                while (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
                    ClassInfo superClass = index.getClassByName(superName);
                    if (superClass == null) continue;
                    if (superClass.interfaceNames().contains(interfaceName)) {
                        return true;
                    }
                    superName = superClass.superName();
                }
                return false;
            });
        }

        public Builder defaultScope(DotName scopeAnnotationName) {
            this.defaultScope = scopeAnnotationName;
            return this;
        }

        public Builder defaultScope(BuiltinScope scope) {
            return this.defaultScope(scope.getName());
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder scopeAlreadyAdded(BiConsumer<DotName, String> consumer) {
            this.scopeAlreadyAdded = consumer;
            return this;
        }

        private Builder and(MatchPredicate other) {
            this.matchPredicate = this.matchPredicate == null ? other : this.matchPredicate.and(other);
            return this;
        }

        public AutoAddScopeBuildItem build() {
            if (this.matchPredicate == null) {
                throw new IllegalStateException("A matching predicate must be set!");
            }
            return new AutoAddScopeBuildItem(this.matchPredicate, this.requiresContainerServices, this.defaultScope, this.unremovable, this.reason, this.priority, this.scopeAlreadyAdded);
        }
    }

    public static interface MatchPredicate {
        public boolean test(ClassInfo var1, Collection<AnnotationInstance> var2, IndexView var3);

        default public MatchPredicate and(final MatchPredicate other) {
            return new MatchPredicate(){

                @Override
                public boolean test(ClassInfo clazz, Collection<AnnotationInstance> annotations, IndexView index) {
                    return this.test(clazz, annotations, index) && other.test(clazz, annotations, index);
                }
            };
        }
    }
}

