/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.configuration.ConfigurationError;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.builder.item.SimpleBuildItem;

public final class QuarkusConfig
extends SimpleBuildItem {
    public static final QuarkusConfig INSTANCE = new QuarkusConfig();
    private static final Map<Object, String> reverseMap = new IdentityHashMap<Object, String>();

    private QuarkusConfig() {
    }

    public static String getString(String configKey, String defaultValue, boolean allowNull) {
        String opt = ConfigProvider.getConfig().getOptionalValue(configKey, String.class).orElse(defaultValue);
        if (opt == null) {
            if (!allowNull) {
                throw QuarkusConfig.requiredConfigMissing(configKey);
            }
            return null;
        }
        String retVal = new String(opt);
        reverseMap.put(retVal, configKey);
        return retVal;
    }

    public static Set<String> getNames(String prefix) {
        HashSet<String> props = new HashSet<String>();
        for (String i : ConfigProvider.getConfig().getPropertyNames()) {
            if (!i.startsWith(prefix)) continue;
            int idex = i.indexOf(46, prefix.length() + 1);
            if (idex == -1) {
                props.add(i.substring(prefix.length() + 1));
                continue;
            }
            props.add(i.substring(prefix.length() + 1, idex));
        }
        return props;
    }

    public static String getConfigKey(Object val) {
        return reverseMap.get(val);
    }

    public static boolean getBoolean(String configKey, String defaultValue) {
        Optional res = ConfigProvider.getConfig().getOptionalValue(configKey, String.class);
        String val = res.orElse(defaultValue);
        if (val == null || val.isEmpty()) {
            return false;
        }
        return QuarkusConfig.asBoolean(val, configKey);
    }

    public static Boolean getBoxedBoolean(String configKey, String defaultValue, boolean allowNull) {
        Optional res = ConfigProvider.getConfig().getOptionalValue(configKey, String.class);
        String val = res.orElse(defaultValue);
        if (val == null || val.isEmpty()) {
            if (!allowNull) {
                throw QuarkusConfig.requiredConfigMissing(configKey);
            }
            return null;
        }
        Boolean result = QuarkusConfig.asBoolean(val, configKey);
        result = new Boolean(result);
        reverseMap.put(result, configKey);
        return result;
    }

    public static int getInt(String configKey, String defaultValue) {
        Optional res = ConfigProvider.getConfig().getOptionalValue(configKey, String.class);
        String val = res.orElse(defaultValue);
        if (val == null || val.isEmpty()) {
            return 0;
        }
        return QuarkusConfig.asInteger(val, configKey);
    }

    public static Integer getBoxedInt(String configKey, String defaultValue, boolean allowNull) {
        Optional res = ConfigProvider.getConfig().getOptionalValue(configKey, String.class);
        String val = res.orElse(defaultValue);
        if (val == null || val.isEmpty()) {
            if (!allowNull) {
                throw QuarkusConfig.requiredConfigMissing(configKey);
            }
            return null;
        }
        Integer result = QuarkusConfig.asInteger(val, configKey);
        result = new Integer(result);
        reverseMap.put(result, configKey);
        return result;
    }

    private static ConfigurationError requiredConfigMissing(String configKey) {
        return new ConfigurationError("Required configuration property '" + configKey + "' was not defined.");
    }

    private static boolean asBoolean(String val, String configKey) {
        String cleanValue = QuarkusConfig.cleanupValue(val);
        if ("true".equals(cleanValue)) {
            return true;
        }
        if ("false".equals(cleanValue)) {
            return false;
        }
        throw new ConfigurationError("Configuration value for property '" + configKey + "' was set to '" + val + "'. A boolean value is expected; set this property to either 'true' or 'false'.");
    }

    private static int asInteger(String val, String configKey) {
        String cleanValue = QuarkusConfig.cleanupValue(val);
        try {
            return Integer.parseInt(cleanValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationError("Configuration value for property '" + configKey + "' was set to '" + val + "'. An integer value is expected; set this property to a decimal integer.");
        }
    }

    private static String cleanupValue(String val) {
        return val.trim().toLowerCase(Locale.ROOT);
    }
}

