/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import org.wildfly.common.Assert;

public class FloatConfigType
extends LeafConfigType {
    private static final MethodDescriptor FLOAT_VALUE_METHOD = MethodDescriptor.ofMethod(Float.class, (String)"floatValue", Float.TYPE, (Class[])new Class[0]);
    final String defaultValue;

    public FloatConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue) {
        super(containingName, container, consumeSegment);
        Assert.checkNotEmptyParam((String)"defaultValue", (String)defaultValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, SmallRyeConfig config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, config);
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            Float floatValue = (Float)config.getValue(name.toString(), Float.class);
            float f = floatValue != null ? floatValue.floatValue() : ((Float)config.convert(this.defaultValue, Float.class)).floatValue();
            field.setFloat(enclosing, f);
        }
        catch (IllegalAccessException e) {
            throw FloatConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        AssignableResultHandle result = body.createVariable(Float.TYPE);
        ResultHandle floatValue = body.checkCast(body.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(Float.class)}), Float.class);
        BranchResult ifNull = body.ifNull(floatValue);
        BytecodeCreator isNull = ifNull.trueBranch();
        isNull.assign(result, isNull.checkCast(isNull.invokeVirtualMethod(FLOAT_VALUE_METHOD, floatValue, new ResultHandle[]{this.getConvertedDefault(isNull, config)}), Float.class));
        BytecodeCreator isNotNull = ifNull.falseBranch();
        isNotNull.assign(result, isNotNull.invokeVirtualMethod(FLOAT_VALUE_METHOD, floatValue, new ResultHandle[0]));
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, result});
    }

    @Override
    public Class<?> getItemClass() {
        return Float.TYPE;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, SmallRyeConfig config, Field field) {
        try {
            field.setFloat(enclosing, ((Float)config.convert(this.defaultValue, Float.class)).floatValue());
        }
        catch (IllegalAccessException e) {
            throw FloatConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, body.invokeVirtualMethod(FLOAT_VALUE_METHOD, this.getConvertedDefault(body, config), new ResultHandle[0])});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle smallRyeConfig) {
        return body.invokeVirtualMethod(FLOAT_VALUE_METHOD, this.getConvertedDefault(body, smallRyeConfig), new ResultHandle[0]);
    }

    private ResultHandle getConvertedDefault(BytecodeCreator body, ResultHandle config) {
        return body.checkCast(body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{body.load(this.defaultValue), body.loadClass(Float.class)}), Float.class);
    }
}

