/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;

public class ObjectConfigType
extends LeafConfigType {
    final String defaultValue;
    final Class<?> expectedType;

    public ObjectConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue, Class<?> expectedType) {
        super(containingName, container, consumeSegment);
        this.defaultValue = defaultValue;
        this.expectedType = expectedType;
    }

    @Override
    public Class<?> getItemClass() {
        return this.expectedType;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, SmallRyeConfig config, Field field) {
        try {
            field.set(enclosing, config.convert(this.defaultValue, this.expectedType));
        }
        catch (IllegalAccessException e) {
            throw ObjectConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{body.load(this.defaultValue), body.loadClass(this.expectedType)})});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle smallRyeConfig) {
        return body.checkCast(body.invokeVirtualMethod(SRC_CONVERT_METHOD, smallRyeConfig, new ResultHandle[]{body.load(this.defaultValue), body.loadClass(this.expectedType)}), this.expectedType);
    }

    void checkLoaded() {
        if (this.expectedType == null) {
            throw ObjectConfigType.notLoadedException();
        }
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, SmallRyeConfig config) {
        if (this.isConsumeSegment()) {
            name.previous();
        }
        this.getContainer().acceptConfigurationValueIntoLeaf(this, name, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle config) {
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        this.getContainer().generateAcceptConfigurationValueIntoLeaf(body, this, name, config);
    }

    @Override
    void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.set(enclosing, this.getValue(name, config, this.expectedType));
        }
        catch (IllegalAccessException e) {
            throw ObjectConfigType.toError(e);
        }
    }

    @Override
    void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.invokeVirtualMethod(SRC_GET_OPT_METHOD, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(this.expectedType)});
        ResultHandle defaultValue = body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{body.load(this.defaultValue), body.loadClass(this.expectedType)});
        ResultHandle value = body.invokeVirtualMethod(OPT_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{defaultValue});
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, value});
    }

    private <T> T getValue(NameIterator name, SmallRyeConfig config, Class<T> expectedType) {
        return (T)config.getOptionalValue(name.toString(), expectedType).orElse(config.convert(this.defaultValue, expectedType));
    }
}

