/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ApplicationArchiveImpl;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.index.ArtifactIndex;
import io.quarkus.deployment.index.ClassPathArtifactResolver;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class ApplicationArchiveBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ApplicationArchiveBuildStep.class);
    private static final String JANDEX_INDEX = "META-INF/jandex.idx";
    IndexDependencyConfiguration config;

    @BuildStep
    ApplicationArchivesBuildItem build(ArchiveRootBuildItem root, ApplicationIndexBuildItem appindex, List<AdditionalApplicationArchiveMarkerBuildItem> appMarkers) throws IOException {
        HashSet<String> markerFiles = new HashSet<String>();
        for (AdditionalApplicationArchiveMarkerBuildItem i : appMarkers) {
            markerFiles.add(i.getFile());
        }
        List<ApplicationArchive> applicationArchives = this.scanForOtherIndexes(Thread.currentThread().getContextClassLoader(), markerFiles, root.getPath(), Collections.emptyList());
        return new ApplicationArchivesBuildItem(new ApplicationArchiveImpl((IndexView)appindex.getIndex(), root.getPath(), null), applicationArchives);
    }

    private List<ApplicationArchive> scanForOtherIndexes(ClassLoader classLoader, Set<String> applicationArchiveFiles, Path appRoot, List<Path> additionalApplicationArchives) throws IOException {
        HashSet<Path> dependenciesToIndex = new HashSet<Path>();
        dependenciesToIndex.addAll(this.getIndexDependencyPaths(classLoader));
        HashSet<String> markers = new HashSet<String>(applicationArchiveFiles);
        markers.add(JANDEX_INDEX);
        dependenciesToIndex.addAll(ApplicationArchiveBuildStep.getMarkerFilePaths(classLoader, markers));
        dependenciesToIndex.remove(appRoot);
        dependenciesToIndex.addAll(additionalApplicationArchives);
        return ApplicationArchiveBuildStep.indexPaths(dependenciesToIndex, classLoader);
    }

    public List<Path> getIndexDependencyPaths(ClassLoader classLoader) {
        ArtifactIndex artifactIndex = new ArtifactIndex(new ClassPathArtifactResolver(classLoader));
        try {
            ArrayList<Path> ret = new ArrayList<Path>();
            for (Map.Entry<String, IndexDependencyConfig> entry : this.config.indexDependency.entrySet()) {
                Path path = entry.getValue().classifier.isEmpty() ? artifactIndex.getPath(entry.getValue().groupId, entry.getValue().artifactId, null) : artifactIndex.getPath(entry.getValue().groupId, entry.getValue().artifactId, entry.getValue().classifier);
                ret.add(path);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ApplicationArchive> indexPaths(Set<Path> dependenciesToIndex, ClassLoader classLoader) throws IOException {
        ArrayList<ApplicationArchive> ret = new ArrayList<ApplicationArchive>();
        for (Path dep : dependenciesToIndex) {
            LOGGER.debugf("Indexing dependency: %s", (Object)dep);
            if (Files.isDirectory(dep, new LinkOption[0])) {
                Index indexView = ApplicationArchiveBuildStep.handleFilePath(dep);
                ret.add(new ApplicationArchiveImpl((IndexView)indexView, dep, null));
                continue;
            }
            Index index = ApplicationArchiveBuildStep.handleJarPath(dep);
            FileSystem fs = FileSystems.newFileSystem(dep, classLoader);
            ret.add(new ApplicationArchiveImpl((IndexView)index, fs.getRootDirectories().iterator().next(), fs));
        }
        return ret;
    }

    private static Collection<? extends Path> getMarkerFilePaths(ClassLoader classLoader, Set<String> applicationArchiveFiles) throws IOException {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String file : applicationArchiveFiles) {
            Enumeration<URL> e = classLoader.getResources(file);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                ret.add(ApplicationArchiveBuildStep.urlToPath(url));
            }
        }
        return ret;
    }

    private static Path urlToPath(URL url) {
        try {
            if (url.getProtocol().equals("jar")) {
                String jarPath = url.getPath().substring(0, url.getPath().lastIndexOf(33));
                return Paths.get(new URI(jarPath));
            }
            if (url.getProtocol().equals("file")) {
                int index = url.getPath().lastIndexOf("/META-INF");
                String pathString = url.getPath().substring(0, index);
                Path path = Paths.get(new URI(url.getProtocol(), url.getHost(), pathString, null));
                return path;
            }
            throw new RuntimeException("Unkown URL type " + url.getProtocol());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Index handleFilePath(Path path) throws IOException {
        Path existing = path.resolve(JANDEX_INDEX);
        if (Files.exists(existing, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(existing.toFile());){
                IndexReader r = new IndexReader((InputStream)in);
                Index index = r.read();
                return index;
            }
        }
        final Indexer indexer = new Indexer();
        Files.walk(path, new FileVisitOption[0]).forEach(new Consumer<Path>(){

            @Override
            public void accept(Path path) {
                if (path.toString().endsWith(".class")) {
                    try (FileInputStream in = new FileInputStream(path.toFile());){
                        indexer.index((InputStream)in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return indexer.complete();
    }

    private static Index handleJarPath(Path path) throws IOException {
        Enumeration<JarEntry> e;
        Indexer indexer = new Indexer();
        try (JarFile file = new JarFile(path.toFile());){
            ZipEntry existing = file.getEntry(JANDEX_INDEX);
            if (existing != null) {
                try (InputStream in = file.getInputStream(existing);){
                    IndexReader r = new IndexReader(in);
                    Index index = r.read();
                    return index;
                }
            }
            e = file.entries();
        }
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream inputStream = file.getInputStream(entry);
            Throwable throwable = null;
            try {
                indexer.index(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return indexer.complete();
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static final class IndexDependencyConfiguration {
        @ConfigItem(name="<<parent>>")
        Map<String, IndexDependencyConfig> indexDependency;

        IndexDependencyConfiguration() {
        }
    }
}

