/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class IndexingUtil {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.deployment.index");
    public static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());

    public static void indexClass(String beanClass, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader) {
        ClassInfo beanInfo;
        block30: {
            DotName beanClassName = DotName.createSimple((String)beanClass);
            if (additionalIndex.contains(beanClassName)) {
                return;
            }
            beanInfo = quarkusIndex.getClassByName(beanClassName);
            if (beanInfo == null) {
                log.debugf("Index bean class: %s", (Object)beanClass);
                try (InputStream stream = IoUtil.readClass(classLoader, beanClass);){
                    beanInfo = indexer.index(stream);
                    additionalIndex.add(beanInfo.name());
                    break block30;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to index: " + beanClass, e);
                }
            }
            additionalIndex.add(beanClassName);
        }
        for (DotName annotationName : beanInfo.annotations().keySet()) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                Throwable throwable = null;
                try {
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    indexer.index(annotationStream);
                    additionalIndex.add(annotationName);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (annotationStream == null) continue;
                    if (throwable != null) {
                        try {
                            annotationStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + beanClass, e);
            }
        }
        if (!beanInfo.superName().equals((Object)OBJECT)) {
            IndexingUtil.indexClass(beanInfo.superName().toString(), indexer, quarkusIndex, additionalIndex, classLoader);
        }
    }

    public static void indexClass(String beanClass, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader, byte[] beanData) {
        ClassInfo beanInfo;
        block29: {
            DotName beanClassName = DotName.createSimple((String)beanClass);
            if (additionalIndex.contains(beanClassName)) {
                return;
            }
            beanInfo = quarkusIndex.getClassByName(beanClassName);
            if (beanInfo == null) {
                log.debugf("Index bean class: %s", (Object)beanClass);
                try (ByteArrayInputStream stream = new ByteArrayInputStream(beanData);){
                    beanInfo = indexer.index((InputStream)stream);
                    additionalIndex.add(beanInfo.name());
                    break block29;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to index: " + beanClass, e);
                }
            }
            additionalIndex.add(beanClassName);
        }
        for (DotName annotationName : beanInfo.annotations().keySet()) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                Throwable throwable = null;
                try {
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    indexer.index(annotationStream);
                    additionalIndex.add(annotationName);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (annotationStream == null) continue;
                    if (throwable != null) {
                        try {
                            annotationStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + beanClass, e);
            }
        }
    }
}

