/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.ConfigurationCustomConverterBuildItem;
import io.quarkus.deployment.builditem.ExtensionClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.configuration.ConfigDefinition;
import io.quarkus.deployment.configuration.ConfigPatternMap;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.recording.ObjectLoader;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSource;
import io.quarkus.runtime.configuration.CidrAddressConverter;
import io.quarkus.runtime.configuration.ConverterFactory;
import io.quarkus.runtime.configuration.DefaultConfigSource;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.InetAddressConverter;
import io.quarkus.runtime.configuration.InetSocketAddressConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.PathConverter;
import io.quarkus.runtime.configuration.RegexConverter;
import io.quarkus.runtime.configuration.SimpleConfigurationProviderResolver;
import io.quarkus.runtime.configuration.ssl.CipherSuiteSelectorConverter;
import io.quarkus.runtime.configuration.ssl.ProtocolConverter;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;

public class ConfigurationSetup {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.configuration");
    public static final String CONFIG_HELPER = "io.quarkus.runtime.generated.ConfigHelper";
    public static final String CONFIG_HELPER_DATA = "io.quarkus.runtime.generated.ConfigHelperData";
    public static final String CONFIG_ROOT = "io.quarkus.runtime.generated.ConfigRoot";
    public static final FieldDescriptor CONFIG_ROOT_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.ConfigHelperData", (String)"configRoot", (String)"io.quarkus.runtime.generated.ConfigRoot");
    private static final MethodDescriptor NI_HAS_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor NI_NEXT_EQUALS = MethodDescriptor.ofMethod(NameIterator.class, (String)"nextSegmentEquals", Boolean.TYPE, (Class[])new Class[]{String.class});
    private static final MethodDescriptor NI_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"next", Void.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor ITR_HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor ITR_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor CF_GET_CONVERTER = MethodDescriptor.ofMethod(ConverterFactory.class, (String)"getConverter", Converter.class, (Class[])new Class[]{SmallRyeConfig.class, Class.class});
    private static final MethodDescriptor CPR_SET_INSTANCE = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"setInstance", Void.TYPE, (Class[])new Class[]{ConfigProviderResolver.class});
    private static final MethodDescriptor SCPR_CONSTRUCT = MethodDescriptor.ofConstructor(SimpleConfigurationProviderResolver.class, (Class[])new Class[]{Config.class});
    private static final MethodDescriptor SRCB_BUILD = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"build", Config.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_WITH_CONVERTER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withConverter", ConfigBuilder.class, (Class[])new Class[]{Class.class, Integer.TYPE, Converter.class});
    private static final MethodDescriptor SRCB_WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", ConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    private static final MethodDescriptor SRCB_ADD_DEFAULT_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"addDefaultSources", ConfigBuilder.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_CONSTRUCT = MethodDescriptor.ofConstructor(SmallRyeConfigBuilder.class, (Class[])new Class[0]);
    private static final MethodDescriptor II_IN_IMAGE_BUILD = MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageBuildtimeCode", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor II_IN_IMAGE_RUN = MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageRuntimeCode", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_WITH_WRAPPER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withWrapper", SmallRyeConfigBuilder.class, (Class[])new Class[]{UnaryOperator.class});
    public static final MethodDescriptor GET_ROOT_METHOD = MethodDescriptor.ofMethod((String)"io.quarkus.runtime.generated.ConfigHelper", (String)"getRoot", (String)"io.quarkus.runtime.generated.ConfigRoot", (String[])new String[0]);
    private static final FieldDescriptor ECS_WRAPPER = FieldDescriptor.of(ExpandingConfigSource.class, (String)"WRAPPER", UnaryOperator.class);

    @BuildStep
    public void setUpConverters(BuildProducer<ConfigurationCustomConverterBuildItem> configurationTypes) {
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, InetSocketAddress.class, InetSocketAddressConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, CidrAddress.class, CidrAddressConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, InetAddress.class, InetAddressConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, Pattern.class, RegexConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, CipherSuiteSelector.class, CipherSuiteSelectorConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, Protocol.class, ProtocolConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, Path.class, PathConverter.class));
    }

    @BuildStep
    public ConfigurationBuildItem initializeConfiguration(List<ConfigurationCustomConverterBuildItem> converters, ExtensionClassLoaderBuildItem extensionClassLoaderBuildItem) throws IOException, ClassNotFoundException {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.withWrapper(ExpandingConfigSource::new);
        builder.addDefaultSources();
        builder.withSources(new ConfigSource[]{new ApplicationPropertiesConfigSource.InJar()});
        for (ConfigurationCustomConverterBuildItem converter : converters) {
            ConfigurationSetup.withConverterHelper(builder, converter.getType(), converter.getPriority(), converter.getConverter());
        }
        SmallRyeConfig src = (SmallRyeConfig)builder.build();
        ConfigDefinition configDefinition = new ConfigDefinition();
        for (Class<?> clazz : ServiceUtil.classesNamedIn(extensionClassLoaderBuildItem.getExtensionClassLoader(), "META-INF/quarkus-config-roots.list")) {
            configDefinition.registerConfigRoot(clazz);
        }
        SmallRyeConfigProviderResolver.instance().registerConfig((Config)src, Thread.currentThread().getContextClassLoader());
        configDefinition.loadConfiguration(src);
        return new ConfigurationBuildItem(configDefinition);
    }

    private static <T> void withConverterHelper(SmallRyeConfigBuilder builder, Class<T> type, int priority, Class<? extends Converter<?>> converterClass) {
        try {
            builder.withConverter(type, priority, converterClass.newInstance());
        }
        catch (InstantiationException e) {
            throw ReflectUtil.toError(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectUtil.toError(e);
        }
    }

    @BuildStep
    void setUpConfigFile(BuildProducer<RunTimeConfigurationSourceBuildItem> configSourceConsumer) {
        configSourceConsumer.produce(new RunTimeConfigurationSourceBuildItem(ApplicationPropertiesConfigSource.InJar.class.getName(), OptionalInt.empty()));
        configSourceConsumer.produce(new RunTimeConfigurationSourceBuildItem(ApplicationPropertiesConfigSource.InFileSystem.class.getName(), OptionalInt.empty()));
    }

    @BuildStep
    RunTimeConfigurationSourceBuildItem writeDefaults(List<RunTimeConfigurationDefaultBuildItem> defaults, Consumer<GeneratedResourceBuildItem> resourceConsumer) throws IOException {
        Properties properties = new Properties();
        for (RunTimeConfigurationDefaultBuildItem item : defaults) {
            String key = item.getKey();
            String value = item.getValue();
            String existing = properties.getProperty(key);
            if (existing != null && !existing.equals(value)) {
                log.warnf("Two conflicting default values were specified for configuration key \"%s\": \"%s\" and \"%s\" (using \"%2$s\")", (Object)key, (Object)existing, (Object)value);
                continue;
            }
            properties.setProperty(key, value);
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            properties.store(osw, "This is the generated set of default configuration values");
            osw.flush();
            resourceConsumer.accept(new GeneratedResourceBuildItem("META-INF/quarkus-default-config.properties", os.toByteArray()));
        }
        return new RunTimeConfigurationSourceBuildItem(DefaultConfigSource.class.getName(), OptionalInt.empty());
    }

    @BuildStep
    void finalizeConfigLoader(ConfigurationBuildItem configurationBuildItem, final Consumer<GeneratedClassBuildItem> classConsumer, Consumer<RuntimeReinitializedClassBuildItem> runTimeInitConsumer, Consumer<BytecodeRecorderObjectLoaderBuildItem> objectLoaderConsumer, List<ConfigurationCustomConverterBuildItem> converters, List<RunTimeConfigurationSourceBuildItem> runTimeSources) {
        FieldDescriptor convertersField;
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                classConsumer.accept(new GeneratedClassBuildItem(false, name, data));
            }
        };
        final ConfigDefinition configDefinition = configurationBuildItem.getConfigDefinition();
        ConfigPatternMap<LeafConfigType> allLeafPatterns = configDefinition.getLeafPatterns();
        ConfigPatternMap<LeafConfigType> runTimePatterns = new ConfigPatternMap<LeafConfigType>();
        ConfigPatternMap<LeafConfigType> staticInitPatterns = new ConfigPatternMap<LeafConfigType>();
        for (String childName : allLeafPatterns.childNames()) {
            ConfigPhase phase = configDefinition.getPhaseByKey(childName);
            if (phase.isReadAtMain()) {
                runTimePatterns.addChild(childName, allLeafPatterns.getChild(childName));
            }
            if (!phase.isReadAtStaticInit()) continue;
            staticInitPatterns.addChild(childName, allLeafPatterns.getChild(childName));
        }
        AccessorFinder accessorMaker = new AccessorFinder();
        configDefinition.generateConfigRootClass(classOutput, accessorMaker);
        try (ClassCreator cc = new ClassCreator(classOutput, CONFIG_HELPER_DATA, null, Object.class.getName(), new String[0]);){
            convertersField = ((FieldCreator)cc.getFieldCreator("$CONVERTERS", Converter[].class).setModifiers(72)).getFieldDescriptor();
            ((FieldCreator)cc.getFieldCreator(CONFIG_ROOT_FIELD).setModifiers(73)).getFieldDescriptor();
        }
        cc = new ClassCreator(classOutput, CONFIG_HELPER, null, Object.class.getName(), new String[0]);
        var15_15 = null;
        try {
            MethodDescriptor createAndRegisterConfig;
            try (MethodCreator carc = cc.getMethodCreator("createAndRegisterConfig", SmallRyeConfig.class, new Class[0]);){
                carc.setModifiers(8);
                ResultHandle builder = carc.newInstance(SRCB_CONSTRUCT, new ResultHandle[0]);
                carc.invokeVirtualMethod(SRCB_ADD_DEFAULT_SOURCES, builder, new ResultHandle[0]);
                int size = runTimeSources.size();
                if (size > 0) {
                    ResultHandle arrayHandle = carc.newArray(ConfigSource[].class, carc.load(size));
                    for (int i = 0; i < size; ++i) {
                        RunTimeConfigurationSourceBuildItem source = runTimeSources.get(i);
                        OptionalInt priority = source.getPriority();
                        ResultHandle val = priority.isPresent() ? carc.newInstance(MethodDescriptor.ofConstructor((Object)source.getClassName(), (Object[])new Object[]{Integer.TYPE}), new ResultHandle[]{carc.load(priority.getAsInt())}) : carc.newInstance(MethodDescriptor.ofConstructor((String)source.getClassName(), (String[])new String[0]), new ResultHandle[0]);
                        carc.writeArrayValue(arrayHandle, i, val);
                    }
                    carc.invokeVirtualMethod(SRCB_WITH_SOURCES, builder, new ResultHandle[]{arrayHandle});
                }
                for (ConfigurationCustomConverterBuildItem converter : converters) {
                    carc.invokeVirtualMethod(SRCB_WITH_CONVERTER, builder, new ResultHandle[]{carc.loadClass(converter.getType()), carc.load(converter.getPriority()), carc.newInstance(MethodDescriptor.ofConstructor(converter.getConverter(), (Class[])new Class[0]), new ResultHandle[0])});
                }
                ResultHandle wrapper = carc.readStaticField(ECS_WRAPPER);
                carc.invokeVirtualMethod(SRCB_WITH_WRAPPER, builder, new ResultHandle[]{wrapper});
                HashSet encountered = new HashSet();
                ArrayList<Class> configTypes = new ArrayList<Class>();
                for (LeafConfigType item : allLeafPatterns) {
                    Class<?> typeClass = item.getItemClass();
                    if (typeClass.isPrimitive() || !encountered.add(typeClass)) continue;
                    configTypes.add(typeClass);
                }
                configTypes.sort(Comparator.comparing(Class::getName));
                int cnt = configTypes.size();
                BranchResult imgRun = carc.ifNonZero(carc.invokeStaticMethod(II_IN_IMAGE_RUN, new ResultHandle[0]));
                try (BytecodeCreator inImageRun = imgRun.trueBranch();){
                    ResultHandle array = inImageRun.readStaticField(convertersField);
                    for (int i = 0; i < cnt; ++i) {
                        inImageRun.invokeVirtualMethod(SRCB_WITH_CONVERTER, builder, new ResultHandle[]{inImageRun.loadClass((Class)configTypes.get(i)), inImageRun.load(100), inImageRun.readArrayValue(array, i)});
                    }
                }
                ResultHandle config = carc.checkCast(carc.invokeVirtualMethod(SRCB_BUILD, builder, new ResultHandle[0]), SmallRyeConfig.class);
                ResultHandle providerResolver = carc.newInstance(SCPR_CONSTRUCT, new ResultHandle[]{config});
                carc.invokeStaticMethod(CPR_SET_INSTANCE, new ResultHandle[]{providerResolver});
                BranchResult imgBuild = carc.ifNonZero(carc.invokeStaticMethod(II_IN_IMAGE_BUILD, new ResultHandle[0]));
                try (BytecodeCreator inImageBuild = imgBuild.trueBranch();){
                    ResultHandle array = inImageBuild.newArray(Converter.class, inImageBuild.load(cnt));
                    for (int i = 0; i < cnt; ++i) {
                        inImageBuild.writeArrayValue(array, i, inImageBuild.invokeStaticMethod(CF_GET_CONVERTER, new ResultHandle[]{config, inImageBuild.loadClass((Class)configTypes.get(i))}));
                    }
                    inImageBuild.writeStaticField(convertersField, array);
                }
                carc.returnValue(carc.checkCast(config, SmallRyeConfig.class));
                createAndRegisterConfig = carc.getMethodDescriptor();
            }
            var18_24 = null;
            try (MethodCreator getRoot = cc.getMethodCreator("getRoot", CONFIG_ROOT, new String[0]);){
                getRoot.setModifiers(9);
                getRoot.returnValue(getRoot.readStaticField(CONFIG_ROOT_FIELD));
            }
            catch (Throwable builder) {
                var18_24 = builder;
                throw builder;
            }
            var18_24 = null;
            try (MethodCreator ccInit = cc.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);){
                ResultHandle mccConfig;
                ccInit.setModifiers(8);
                BranchResult ccIfImage = ccInit.ifNonZero(ccInit.invokeStaticMethod(MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageRuntimeCode", Boolean.TYPE, (Class[])new Class[0]), new ResultHandle[0]));
                try (BytecodeCreator ccIsNotImage = ccIfImage.falseBranch();){
                    mccConfig = ccIsNotImage.invokeStaticMethod(createAndRegisterConfig, new ResultHandle[0]);
                    ccIsNotImage.newInstance(MethodDescriptor.ofConstructor((Object)CONFIG_ROOT, (Object[])new Object[]{SmallRyeConfig.class}), new ResultHandle[]{mccConfig});
                    this.writeParsing(cc, ccIsNotImage, mccConfig, staticInitPatterns);
                }
                var21_34 = null;
                try (BytecodeCreator ccIsImage = ccIfImage.trueBranch();){
                    mccConfig = ccIsImage.invokeStaticMethod(createAndRegisterConfig, new ResultHandle[0]);
                    this.writeParsing(cc, ccIsImage, mccConfig, runTimePatterns);
                }
                catch (Throwable throwable) {
                    var21_34 = throwable;
                    throw throwable;
                }
                ccInit.returnValue(null);
            }
            catch (Throwable throwable) {
                var18_24 = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            var15_15 = throwable;
            throw throwable;
        }
        finally {
            if (cc != null) {
                if (var15_15 != null) {
                    try {
                        cc.close();
                    }
                    catch (Throwable throwable) {
                        var15_15.addSuppressed(throwable);
                    }
                } else {
                    cc.close();
                }
            }
        }
        objectLoaderConsumer.accept(new BytecodeRecorderObjectLoaderBuildItem(new ObjectLoader(){

            @Override
            public ResultHandle load(BytecodeCreator body, Object obj) {
                ConfigDefinition.RootInfo rootInfo = configDefinition.getInstanceInfo(obj);
                if (rootInfo == null) {
                    return null;
                }
                if (!rootInfo.getConfigPhase().isAvailableAtRun()) {
                    String msg = String.format("You are trying to use a ConfigRoot[%s] at runtime whose phase[%s] does not allow this", rootInfo.getRootClass().getName(), rootInfo.getConfigPhase());
                    throw new IllegalStateException(msg);
                }
                FieldDescriptor fieldDescriptor = rootInfo.getFieldDescriptor();
                ResultHandle configRoot = body.invokeStaticMethod(GET_ROOT_METHOD, new ResultHandle[0]);
                return body.readInstanceField(fieldDescriptor, configRoot);
            }
        }));
        runTimeInitConsumer.accept(new RuntimeReinitializedClassBuildItem(CONFIG_HELPER));
    }

    private void writeParsing(ClassCreator cc, BytecodeCreator body, ResultHandle config, ConfigPatternMap<LeafConfigType> keyMap) {
        ResultHandle iterable = body.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getPropertyNames", Iterable.class, (Class[])new Class[0]), config, new ResultHandle[0]);
        ResultHandle iterator = body.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), iterable, new ResultHandle[0]);
        try (BytecodeCreator loop = body.createScope();){
            BranchResult ifHasNext = loop.ifNonZero(loop.invokeInterfaceMethod(ITR_HAS_NEXT, iterator, new ResultHandle[0]));
            try (BytecodeCreator hasNext = ifHasNext.trueBranch();){
                ResultHandle key = hasNext.checkCast(hasNext.invokeInterfaceMethod(ITR_NEXT, iterator, new ResultHandle[0]), String.class);
                ResultHandle keyIter = hasNext.newInstance(MethodDescriptor.ofConstructor(NameIterator.class, (Class[])new Class[]{String.class}), new ResultHandle[]{key});
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch().continueScope(loop);
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{hasNext.load("quarkus")})).falseBranch().continueScope(loop);
                hasNext.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                hasNext.invokeStaticMethod(this.generateParserBody(cc, keyMap, new StringBuilder("parseKey"), new HashMap<String, MethodDescriptor>()), new ResultHandle[]{config, keyIter});
                hasNext.continueScope(loop);
            }
        }
        body.returnValue(body.loadNull());
    }

    private MethodDescriptor generateParserBody(ClassCreator cc, ConfigPatternMap<LeafConfigType> keyMap, StringBuilder methodName, Map<String, MethodDescriptor> parseMethodCache) {
        String methodNameStr = methodName.toString();
        MethodDescriptor existing = parseMethodCache.get(methodNameStr);
        if (existing != null) {
            return existing;
        }
        try (MethodCreator body = cc.getMethodCreator(methodName.toString(), Void.TYPE, new Class[]{SmallRyeConfig.class, NameIterator.class});){
            Object object;
            body.setModifiers(10);
            ResultHandle config = body.getMethodParam(0);
            ResultHandle keyIter = body.getMethodParam(1);
            LeafConfigType matched = keyMap.getMatched();
            try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                if (matched != null) {
                    matched.generateAcceptConfigurationValue(matchedBody, keyIter, config);
                }
                matchedBody.returnValue(null);
            }
            boolean hasWildCard = false;
            Iterable<String> names = keyMap.childNames();
            for (String name : names) {
                if (name.equals("{*}")) {
                    hasWildCard = true;
                    continue;
                }
                BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();
                Throwable throwable = null;
                try {
                    nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append(name);
                    nameMatched.invokeStaticMethod(this.generateParserBody(cc, keyMap.getChild(name), methodName, parseMethodCache), new ResultHandle[]{config, keyIter});
                    methodName.setLength(length);
                    nameMatched.returnValue(null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameMatched == null) continue;
                    if (throwable != null) {
                        try {
                            nameMatched.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameMatched.close();
                }
            }
            if (hasWildCard) {
                BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).trueBranch();
                object = null;
                try {
                    matchedBody.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append("wildcard");
                    matchedBody.invokeStaticMethod(this.generateParserBody(cc, keyMap.getChild("{*}"), methodName, parseMethodCache), new ResultHandle[]{config, keyIter});
                    methodName.setLength(length);
                    matchedBody.returnValue(null);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (matchedBody != null) {
                        if (object != null) {
                            try {
                                matchedBody.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            matchedBody.close();
                        }
                    }
                }
            }
            body.returnValue(null);
            MethodDescriptor md = body.getMethodDescriptor();
            parseMethodCache.put(methodNameStr, md);
            object = md;
            return object;
        }
    }

    @BuildStep
    void writeDefaultConfiguration() {
    }
}

