/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveHierarchyBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.VoidType;
import org.jboss.logging.Logger;

public class ReflectiveHierarchyStep {
    private static final Logger log = Logger.getLogger(ReflectiveHierarchyStep.class);
    @Inject
    List<ReflectiveHierarchyBuildItem> hierarchy;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;

    @BuildStep
    public void build() throws Exception {
        HashSet<DotName> processedReflectiveHierarchies = new HashSet<DotName>();
        for (ReflectiveHierarchyBuildItem i : this.hierarchy) {
            this.addReflectiveHierarchy(i.getType(), processedReflectiveHierarchies);
        }
    }

    private void addReflectiveHierarchy(Type type, Set<DotName> processedReflectiveHierarchies) {
        block6: {
            block7: {
                block5: {
                    if (type instanceof VoidType || type instanceof PrimitiveType || type instanceof UnresolvedTypeVariable) {
                        return;
                    }
                    if (!(type instanceof ClassType)) break block5;
                    if (this.skipClass(type.name(), processedReflectiveHierarchies)) {
                        return;
                    }
                    this.addClassTypeHierarchy(type.name(), processedReflectiveHierarchies);
                    for (ClassInfo subclass : this.combinedIndexBuildItem.getIndex().getAllKnownSubclasses(type.name())) {
                        this.addClassTypeHierarchy(subclass.name(), processedReflectiveHierarchies);
                    }
                    for (ClassInfo subclass : this.combinedIndexBuildItem.getIndex().getAllKnownImplementors(type.name())) {
                        this.addClassTypeHierarchy(subclass.name(), processedReflectiveHierarchies);
                    }
                    break block6;
                }
                if (!(type instanceof ArrayType)) break block7;
                this.addReflectiveHierarchy(type.asArrayType().component(), processedReflectiveHierarchies);
                break block6;
            }
            if (!(type instanceof ParameterizedType)) break block6;
            ParameterizedType p = (ParameterizedType)type;
            this.addReflectiveHierarchy(p.owner(), processedReflectiveHierarchies);
            for (Type arg : p.arguments()) {
                this.addReflectiveHierarchy(arg, processedReflectiveHierarchies);
            }
        }
    }

    private void addClassTypeHierarchy(DotName name, Set<DotName> processedReflectiveHierarchies) {
        if (this.skipClass(name, processedReflectiveHierarchies)) {
            return;
        }
        processedReflectiveHierarchies.add(name);
        this.reflectiveClass.produce(new ReflectiveClassBuildItem(true, true, name.toString()));
        ClassInfo info = this.combinedIndexBuildItem.getIndex().getClassByName(name);
        if (info == null) {
            log.warn((Object)("Unable to find annotation info for " + name + ", either it should be added to the Jandex index or it might be incorrectly registered for reflection."));
        } else {
            this.addClassTypeHierarchy(info.superName(), processedReflectiveHierarchies);
            for (FieldInfo i : info.fields()) {
                this.addReflectiveHierarchy(i.type(), processedReflectiveHierarchies);
            }
            for (MethodInfo method : info.methods()) {
                if (method.parameters().size() != 0) continue;
                this.addReflectiveHierarchy(method.returnType(), processedReflectiveHierarchies);
            }
        }
    }

    private boolean skipClass(DotName name, Set<DotName> processedReflectiveHierarchies) {
        return name.toString().startsWith("java.") || processedReflectiveHierarchies.contains(name);
    }
}

