/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.BuildTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.BuildTimeRunTimeFixedConfigurationBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.StaticBytecodeRecorderBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.Template;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.builder.BuildChainBuilder;
import org.jboss.builder.BuildContext;
import org.jboss.builder.BuildStepBuilder;
import org.jboss.builder.ConsumeFlag;
import org.jboss.builder.ConsumeFlags;
import org.jboss.builder.ProduceFlag;
import org.jboss.builder.ProduceFlags;
import org.jboss.builder.item.BuildItem;
import org.jboss.builder.item.MultiBuildItem;
import org.jboss.builder.item.SimpleBuildItem;
import org.wildfly.common.function.Functions;

public final class ExtensionLoader {
    private ExtensionLoader() {
    }

    private static boolean isTemplate(AnnotatedElement element) {
        return element.isAnnotationPresent(Template.class);
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Consumer<BuildChainBuilder> result = Functions.discardingConsumer();
        for (Class<?> clazz : ServiceUtil.classesNamedIn(classLoader, "META-INF/quarkus-build-steps.list")) {
            result = result.andThen(ExtensionLoader.loadStepsFrom(clazz));
        }
        return result;
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(final Class<?> clazz) {
        Method[] methods;
        Field[] fields;
        List ctorParamFns;
        Parameter[] ctorParameters;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Consumer<BuildChainBuilder> chainConfig = Functions.discardingConsumer();
        Consumer<BuildStepBuilder> stepConfig = Functions.discardingConsumer();
        BiConsumer<BuildContext, Object> stepInstanceSetup = Functions.discardingBiConsumer();
        if (constructors.length != 1) {
            throw ExtensionLoader.reportError(clazz, "Build step classes must have exactly one constructor");
        }
        EnumSet<ConfigPhase> consumingConfigPhases = EnumSet.noneOf(ConfigPhase.class);
        final Constructor<?> constructor = constructors[0];
        if (!Modifier.isPublic(constructor.getModifiers())) {
            constructor.setAccessible(true);
        }
        if ((ctorParameters = constructor.getParameters()).length == 0) {
            ctorParamFns = Collections.emptyList();
        } else {
            ctorParamFns = new ArrayList(ctorParameters.length);
            for (Parameter parameter : ctorParameters) {
                Class<SimpleBuildItem> buildItemClass;
                Type parameterType = parameter.getParameterizedType();
                Class<?> parameterClass = parameter.getType();
                if (ReflectUtil.rawTypeExtends(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOf(parameterType).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> bc.consume(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isListOf(parameterType, MultiBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(MultiBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> bc.consumeMulti(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isConsumerOf(parameterType, BuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.produces(buildItemClass));
                    ctorParamFns.add(bc -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                    continue;
                }
                if (ReflectUtil.isBuildProducerOf(parameterType, BuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.produces(buildItemClass));
                    ctorParamFns.add(bc -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                    continue;
                }
                if (ReflectUtil.isOptionalOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                    ctorParamFns.add(bc -> Optional.ofNullable(bc.consume(buildItemClass)));
                    continue;
                }
                if (ReflectUtil.isSupplierOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> () -> bc.consume(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isSupplierOfOptionalOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(parameterType, 0), 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                    ctorParamFns.add(bc -> () -> Optional.ofNullable(bc.consume(buildItemClass)));
                    continue;
                }
                if (ReflectUtil.rawTypeOf(parameterType) == Executor.class) {
                    ctorParamFns.add(BuildContext::getExecutor);
                    continue;
                }
                if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                    ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                    ConfigPhase phase = annotation.phase();
                    consumingConfigPhases.add(phase);
                    if (phase == ConfigPhase.BUILD_TIME) {
                        ctorParamFns.add(bc -> ((BuildTimeConfigurationBuildItem)bc.consume(BuildTimeConfigurationBuildItem.class)).getConfigDefinition().getRealizedInstance(parameterClass));
                        continue;
                    }
                    if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                        ctorParamFns.add(bc -> ((BuildTimeRunTimeFixedConfigurationBuildItem)bc.consume(BuildTimeRunTimeFixedConfigurationBuildItem.class)).getConfigDefinition().getRealizedInstance(parameterClass));
                        continue;
                    }
                    if (phase == ConfigPhase.RUN_TIME) {
                        ctorParamFns.add(bc -> ((RunTimeConfigurationBuildItem)bc.consume(RunTimeConfigurationBuildItem.class)).getConfigDefinition().getRealizedInstance(parameterClass));
                        continue;
                    }
                    throw ExtensionLoader.reportError(parameterClass, "Unknown value for ConfigPhase");
                }
                if (ExtensionLoader.isTemplate(parameterClass)) {
                    throw ExtensionLoader.reportError(parameter, "Bytecode recording templates disallowed on constructor parameters");
                }
                throw ExtensionLoader.reportError(parameter, "Unsupported constructor parameter type " + parameterType);
            }
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Class<SimpleBuildItem> buildItemClass;
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                field.setAccessible(true);
            }
            Type fieldType = field.getGenericType();
            Class<?> fieldClass = field.getType();
            if (ReflectUtil.rawTypeExtends(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOf(fieldType).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.consume(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isListOf(fieldType, MultiBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(MultiBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.consumeMulti(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isConsumerOf(fieldType, BuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(BuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.produces(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, arg_0 -> ((BuildContext)bc).produce(arg_0)));
                continue;
            }
            if (ReflectUtil.isBuildProducerOf(fieldType, BuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(BuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.produces(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, arg_0 -> ((BuildContext)bc).produce(arg_0)));
                continue;
            }
            if (ReflectUtil.isOptionalOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, Optional.ofNullable(bc.consume(buildItemClass))));
                continue;
            }
            if (ReflectUtil.isSupplierOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, () -> bc.consume(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isSupplierOfOptionalOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(fieldType, 0), 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, () -> Optional.ofNullable(bc.consume(buildItemClass))));
                continue;
            }
            if (fieldClass == Executor.class) {
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.getExecutor()));
                continue;
            }
            if (fieldClass.isAnnotationPresent(ConfigRoot.class)) {
                ConfigRoot annotation = fieldClass.getAnnotation(ConfigRoot.class);
                ConfigPhase phase = annotation.phase();
                consumingConfigPhases.add(phase);
                if (phase == ConfigPhase.BUILD_TIME) {
                    stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> {
                        BuildTimeConfigurationBuildItem configurationBuildItem = (BuildTimeConfigurationBuildItem)bc.consume(BuildTimeConfigurationBuildItem.class);
                        ReflectUtil.setFieldVal(field, o, configurationBuildItem.getConfigDefinition().getRealizedInstance(fieldClass));
                    });
                    continue;
                }
                if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                    stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> {
                        BuildTimeRunTimeFixedConfigurationBuildItem configurationBuildItem = (BuildTimeRunTimeFixedConfigurationBuildItem)bc.consume(BuildTimeRunTimeFixedConfigurationBuildItem.class);
                        ReflectUtil.setFieldVal(field, o, configurationBuildItem.getConfigDefinition().getRealizedInstance(fieldClass));
                    });
                    continue;
                }
                if (phase == ConfigPhase.RUN_TIME) {
                    stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> {
                        RunTimeConfigurationBuildItem configurationBuildItem = (RunTimeConfigurationBuildItem)bc.consume(RunTimeConfigurationBuildItem.class);
                        ReflectUtil.setFieldVal(field, o, configurationBuildItem.getConfigDefinition().getRealizedInstance(fieldClass));
                    });
                    continue;
                }
                throw ExtensionLoader.reportError(fieldClass, "Unknown value for ConfigPhase");
            }
            if (ExtensionLoader.isTemplate(fieldClass)) {
                throw ExtensionLoader.reportError(field, "Bytecode recording templates disallowed on fields");
            }
            throw ExtensionLoader.reportError(field, "Unsupported field type " + fieldType);
        }
        for (final Method method : methods = clazz.getDeclaredMethods()) {
            BiConsumer<BuildContext, Object> resultConsumer;
            List methodParamFns;
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || !method.isAnnotationPresent(BuildStep.class)) continue;
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            BuildStep buildStep = method.getAnnotation(BuildStep.class);
            String[] archiveMarkers = buildStep.applicationArchiveMarkers();
            String[] capabilities = buildStep.providesCapabilities();
            Parameter[] methodParameters = method.getParameters();
            final Record recordAnnotation = method.getAnnotation(Record.class);
            final boolean isRecorder = recordAnnotation != null;
            Consumer<BuildStepBuilder> methodStepConfig = Functions.discardingConsumer();
            if (archiveMarkers.length > 0) {
                chainConfig = chainConfig.andThen(bcb -> bcb.addBuildStep(bc -> {
                    for (String marker : archiveMarkers) {
                        bc.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(marker));
                    }
                }).produces(AdditionalApplicationArchiveMarkerBuildItem.class).build());
            }
            if (capabilities.length > 0) {
                chainConfig = chainConfig.andThen(bcb -> bcb.addBuildStep(bc -> {
                    for (String capability : capabilities) {
                        bc.produce((BuildItem)new CapabilityBuildItem(capability));
                    }
                }).produces(CapabilityBuildItem.class).build());
            }
            if (isRecorder) {
                assert (recordAnnotation != null);
                ExecutionTime executionTime = recordAnnotation.value();
                boolean optional = recordAnnotation.optional();
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(executionTime == ExecutionTime.STATIC_INIT ? StaticBytecodeRecorderBuildItem.class : MainBytecodeRecorderBuildItem.class, optional ? ProduceFlags.of((ProduceFlag)ProduceFlag.WEAK) : ProduceFlags.NONE));
            }
            Object methodConsumingConfigPhases = consumingConfigPhases.clone();
            if (methodParameters.length == 0) {
                methodParamFns = Collections.emptyList();
            } else {
                methodParamFns = new ArrayList(methodParameters.length);
                for (Parameter parameter : methodParameters) {
                    Class<SimpleBuildItem> buildItemClass;
                    Type parameterType = parameter.getParameterizedType();
                    Class<?> parameterClass = parameter.getType();
                    if (ReflectUtil.rawTypeExtends(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = parameterClass.asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> bc.consume(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isListOf(parameterType, MultiBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(MultiBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> bc.consumeMulti(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isConsumerOf(parameterType, BuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass));
                        methodParamFns.add((bc, bri) -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                        continue;
                    }
                    if (ReflectUtil.isBuildProducerOf(parameterType, BuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass));
                        methodParamFns.add((bc, bri) -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                        continue;
                    }
                    if (ReflectUtil.isOptionalOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                        methodParamFns.add((bc, bri) -> Optional.ofNullable(bc.consume(buildItemClass)));
                        continue;
                    }
                    if (ReflectUtil.isSupplierOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> () -> bc.consume(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isSupplierOfOptionalOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(parameterType, 0), 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                        methodParamFns.add((bc, bri) -> () -> Optional.ofNullable(bc.consume(buildItemClass)));
                        continue;
                    }
                    if (ReflectUtil.rawTypeOf(parameterType) == Executor.class) {
                        methodParamFns.add((bc, bri) -> bc.getExecutor());
                        continue;
                    }
                    if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                        ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                        ConfigPhase phase = annotation.phase();
                        ((AbstractCollection)methodConsumingConfigPhases).add(phase);
                        if (phase == ConfigPhase.BUILD_TIME) {
                            methodParamFns.add((bc, bri) -> {
                                BuildTimeConfigurationBuildItem configurationBuildItem = (BuildTimeConfigurationBuildItem)bc.consume(BuildTimeConfigurationBuildItem.class);
                                return configurationBuildItem.getConfigDefinition().getRealizedInstance(parameterClass);
                            });
                            continue;
                        }
                        if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                            methodParamFns.add((bc, bri) -> {
                                BuildTimeRunTimeFixedConfigurationBuildItem configurationBuildItem = (BuildTimeRunTimeFixedConfigurationBuildItem)bc.consume(BuildTimeRunTimeFixedConfigurationBuildItem.class);
                                return configurationBuildItem.getConfigDefinition().getRealizedInstance(parameterClass);
                            });
                            continue;
                        }
                        if (phase == ConfigPhase.RUN_TIME) {
                            methodParamFns.add((bc, bri) -> {
                                RunTimeConfigurationBuildItem configurationBuildItem = (RunTimeConfigurationBuildItem)bc.consume(RunTimeConfigurationBuildItem.class);
                                return configurationBuildItem.getConfigDefinition().getRealizedInstance(parameterClass);
                            });
                            continue;
                        }
                        throw ExtensionLoader.reportError(parameterClass, "Unknown value for ConfigPhase");
                    }
                    if (ExtensionLoader.isTemplate(parameter.getType())) {
                        if (!isRecorder) {
                            throw ExtensionLoader.reportError(parameter, "Cannot pass templates to method which is not annotated with " + Record.class);
                        }
                        methodParamFns.add((bc, bri) -> {
                            assert (bri != null);
                            return bri.getRecordingProxy(parameterClass);
                        });
                        continue;
                    }
                    if (parameter.getType() == RecorderContext.class || parameter.getType() == BytecodeRecorderImpl.class) {
                        if (!isRecorder) {
                            throw ExtensionLoader.reportError(parameter, "Cannot pass recorder context to method which is not annotated with " + Record.class);
                        }
                        methodParamFns.add((bc, bri) -> bri);
                        continue;
                    }
                    throw ExtensionLoader.reportError(parameter, "Unsupported method parameter " + parameterType);
                }
            }
            Type returnType = method.getGenericReturnType();
            if (ReflectUtil.rawTypeIs(returnType, Void.TYPE)) {
                resultConsumer = Functions.discardingBiConsumer();
            } else if (ReflectUtil.rawTypeExtends(returnType, BuildItem.class)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(method.getReturnType().asSubclass(BuildItem.class)));
                resultConsumer = (bc, o) -> {
                    if (o != null) {
                        bc.produce((BuildItem)o);
                    }
                };
            } else if (ReflectUtil.isOptionalOf(returnType, BuildItem.class)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(ReflectUtil.rawTypeOfParameter(returnType, 0).asSubclass(BuildItem.class)));
                resultConsumer = (bc, o) -> ((Optional)o).ifPresent(arg_0 -> ((BuildContext)bc).produce(arg_0));
            } else if (ReflectUtil.isListOf(returnType, MultiBuildItem.class)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(ReflectUtil.rawTypeOfParameter(returnType, 0).asSubclass(MultiBuildItem.class)));
                resultConsumer = (bc, o) -> {
                    if (o != null) {
                        bc.produce((List)o);
                    }
                };
            } else {
                throw ExtensionLoader.reportError(method, "Unsupported method return type " + returnType);
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.RUN_TIME)) {
                if (isRecorder && recordAnnotation.value() == ExecutionTime.STATIC_INIT) {
                    throw ExtensionLoader.reportError(method, "Bytecode recorder is static but an injected config object is declared as run time");
                }
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(RunTimeConfigurationBuildItem.class));
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BUILD_AND_RUN_TIME_FIXED)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(BuildTimeRunTimeFixedConfigurationBuildItem.class));
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BUILD_TIME)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(BuildTimeConfigurationBuildItem.class));
            }
            Consumer<BuildStepBuilder> finalStepConfig = stepConfig.andThen(methodStepConfig).andThen(BuildStepBuilder::build);
            final BiConsumer<BuildContext, Object> finalStepInstanceSetup = stepInstanceSetup;
            final String name = clazz.getName() + "#" + method.getName();
            chainConfig = chainConfig.andThen(bcb -> finalStepConfig.accept(bcb.addBuildStep(new org.jboss.builder.BuildStep(){

                public void execute(BuildContext bc) {
                    Object result;
                    Object instance;
                    Object[] ctorArgs = new Object[ctorParamFns.size()];
                    for (int i = 0; i < ctorArgs.length; ++i) {
                        ctorArgs[i] = ((Function)ctorParamFns.get(i)).apply(bc);
                    }
                    try {
                        instance = constructor.newInstance(ctorArgs);
                    }
                    catch (InstantiationException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (InvocationTargetException e) {
                        try {
                            throw e.getCause();
                        }
                        catch (Error | RuntimeException e2) {
                            throw e2;
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException(t);
                        }
                    }
                    finalStepInstanceSetup.accept(bc, instance);
                    Object[] methodArgs = new Object[methodParamFns.size()];
                    BytecodeRecorderImpl bri = isRecorder ? new BytecodeRecorderImpl(recordAnnotation.value() == ExecutionTime.STATIC_INIT, clazz.getSimpleName(), method.getName()) : null;
                    for (int i = 0; i < methodArgs.length; ++i) {
                        methodArgs[i] = ((BiFunction)methodParamFns.get(i)).apply(bc, bri);
                    }
                    try {
                        result = method.invoke(instance, methodArgs);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (InvocationTargetException e) {
                        try {
                            throw e.getCause();
                        }
                        catch (Error | RuntimeException e2) {
                            throw e2;
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException(t);
                        }
                    }
                    resultConsumer.accept(bc, result);
                    if (isRecorder) {
                        if (recordAnnotation.value() == ExecutionTime.STATIC_INIT) {
                            bc.produce((BuildItem)new StaticBytecodeRecorderBuildItem(bri));
                        } else {
                            bc.produce((BuildItem)new MainBytecodeRecorderBuildItem(bri));
                        }
                    }
                }

                public String toString() {
                    return name;
                }
            })));
        }
        return chainConfig;
    }

    private static IllegalArgumentException reportError(AnnotatedElement e, String msg) {
        if (e instanceof Member) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Member)((Object)e)).getDeclaringClass());
        }
        if (e instanceof Parameter) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Parameter)e).getDeclaringExecutable() + " of " + ((Parameter)e).getDeclaringExecutable().getDeclaringClass());
        }
        return new IllegalArgumentException(msg + " at " + e);
    }
}

