/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.substrate;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.builder.item.MultiBuildItem;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class ReflectiveMethodBuildItem
extends MultiBuildItem {
    final String declaringClass;
    final String name;
    final String[] params;

    public ReflectiveMethodBuildItem(MethodInfo methodInfo) {
        String[] params = new String[methodInfo.parameters().size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = ((Type)methodInfo.parameters().get(i)).name().toString();
        }
        this.name = methodInfo.name();
        this.params = params;
        this.declaringClass = methodInfo.declaringClass().name().toString();
    }

    public ReflectiveMethodBuildItem(Method method) {
        String[] params = new String[method.getParameterTypes().length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = method.getParameterTypes()[i].getName();
        }
        this.params = params;
        this.name = method.getName();
        this.declaringClass = method.getDeclaringClass().getName();
    }

    public String getName() {
        return this.name;
    }

    public String[] getParams() {
        return this.params;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReflectiveMethodBuildItem that = (ReflectiveMethodBuildItem)((Object)o);
        return Objects.equals(this.declaringClass, that.declaringClass) && Objects.equals(this.name, that.name) && Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringClass, this.name);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }
}

