/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.OptionalInt;
import org.wildfly.common.Assert;

public class IntConfigType
extends LeafConfigType {
    private static final MethodDescriptor OPTINT_OR_ELSE_METHOD = MethodDescriptor.ofMethod(OptionalInt.class, (String)"orElse", Integer.TYPE, (Class[])new Class[]{Integer.TYPE});
    private static final MethodDescriptor INT_VALUE_METHOD = MethodDescriptor.ofMethod(Integer.class, (String)"intValue", Integer.TYPE, (Class[])new Class[0]);
    final String defaultValue;

    public IntConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue) {
        super(containingName, container, consumeSegment);
        Assert.checkNotEmptyParam((String)"defaultValue", (String)defaultValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, SmallRyeConfig config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, config);
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.setInt(enclosing, ((OptionalInt)config.getValue(name.toString(), OptionalInt.class)).orElse((Integer)config.convert(this.defaultValue, Integer.class)));
        }
        catch (IllegalAccessException e) {
            throw IntConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.checkCast(body.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(OptionalInt.class)}), OptionalInt.class);
        ResultHandle convertedDefault = this.getConvertedDefault(body, config);
        ResultHandle defaultedValue = body.checkCast(body.invokeVirtualMethod(OPTINT_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{convertedDefault}), Integer.class);
        ResultHandle intValue = body.invokeVirtualMethod(INT_VALUE_METHOD, defaultedValue, new ResultHandle[0]);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, intValue});
    }

    @Override
    public Class<?> getItemClass() {
        return Integer.TYPE;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, SmallRyeConfig config, Field field) {
        try {
            field.setInt(enclosing, (Integer)config.convert(this.defaultValue, Integer.class));
        }
        catch (IllegalAccessException e) {
            throw IntConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, body.invokeVirtualMethod(INT_VALUE_METHOD, this.getConvertedDefault(body, config), new ResultHandle[0])});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle smallRyeConfig) {
        return body.invokeVirtualMethod(INT_VALUE_METHOD, this.getConvertedDefault(body, smallRyeConfig), new ResultHandle[0]);
    }

    private ResultHandle getConvertedDefault(BytecodeCreator body, ResultHandle config) {
        return body.checkCast(body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{body.load(this.defaultValue), body.loadClass(Integer.class)}), Integer.class);
    }
}

