/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.logging;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigurationCustomConverterBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateSystemPropertyBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.runtime.logging.InitialConfigurator;
import io.quarkus.runtime.logging.LevelConverter;
import io.quarkus.runtime.logging.LogConfig;
import io.quarkus.runtime.logging.LoggingSetupTemplate;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.jboss.logmanager.EmbeddedConfigurator;

public final class LoggingResourceProcessor {
    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce(new LogCleanupFilterBuildItem("org.jboss.threads", "JBoss Threads version"));
    }

    @BuildStep
    SystemPropertyBuildItem setProperty() {
        return new SystemPropertyBuildItem("java.util.logging.manager", "org.jboss.logmanager.LogManager");
    }

    @BuildStep
    void setUpDefaultLevels(List<LogCategoryBuildItem> categories, Consumer<RunTimeConfigurationDefaultBuildItem> configOutput) {
        for (LogCategoryBuildItem category : categories) {
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.category.\"" + category.getCategory() + "\".level", category.getLevel().toString()));
        }
    }

    @BuildStep
    void setUpDefaultLogCleanupFilters(List<LogCleanupFilterBuildItem> logCleanupFilters, Consumer<RunTimeConfigurationDefaultBuildItem> configOutput) {
        for (LogCleanupFilterBuildItem logCleanupFilter : logCleanupFilters) {
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.filter.\"" + logCleanupFilter.getFilterElement().getLoggerName() + "\".if-starts-with", logCleanupFilter.getFilterElement().getMessageStart()));
        }
    }

    @BuildStep
    void miscSetup(Consumer<RuntimeInitializedClassBuildItem> runtimeInit, Consumer<SubstrateSystemPropertyBuildItem> systemProp, Consumer<ServiceProviderBuildItem> provider) {
        runtimeInit.accept(new RuntimeInitializedClassBuildItem("org.jboss.logmanager.formatters.TrueColorHolder"));
        systemProp.accept(new SubstrateSystemPropertyBuildItem("java.util.logging.manager", "org.jboss.logmanager.LogManager"));
        provider.accept(new ServiceProviderBuildItem(EmbeddedConfigurator.class.getName(), InitialConfigurator.class.getName()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupLoggingRuntimeInit(LoggingSetupTemplate setupTemplate, LogConfig log) {
        setupTemplate.initializeLogging(log);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupLoggingStaticInit(LoggingSetupTemplate setupTemplate) {
        setupTemplate.initializeLoggingForImageBuild();
    }

    @BuildStep
    ConfigurationCustomConverterBuildItem setUpLevelConverter() {
        return new ConfigurationCustomConverterBuildItem(200, Level.class, LevelConverter.class);
    }
}

