/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.runtime.annotations.Template;
import io.quarkus.runtime.logging.CategoryConfig;
import io.quarkus.runtime.logging.CleanupFilterConfig;
import io.quarkus.runtime.logging.InitialConfigurator;
import io.quarkus.runtime.logging.LogCleanupFilter;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogConfig;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;

@Template
public class LoggingSetupTemplate {
    /*
     * WARNING - void declaration
     */
    public void initializeLogging(LogConfig config) {
        ConsoleHandler handler;
        Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        Object errorManager = new OnlyOnceErrorManager();
        rootLogger.setLevel(config.level.orElse(Level.INFO));
        for (Map.Entry<String, CategoryConfig> entry : categories.entrySet()) {
            String name = entry.getKey();
            Logger logger = logContext.getLogger(name);
            CategoryConfig categoryConfig = entry.getValue();
            if ("inherit".equals(categoryConfig.level)) continue;
            logger.setLevelName(categoryConfig.level);
        }
        Map<String, CleanupFilterConfig> filters = config.filters;
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size());
        for (Map.Entry entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement((String)entry.getKey(), ((CleanupFilterConfig)entry.getValue()).ifStartsWith));
        }
        ArrayList<ConsoleHandler> handlers = new ArrayList<ConsoleHandler>(2);
        if (config.console.enable) {
            void var9_14;
            if (config.console.color && System.console() != null) {
                ColorPatternFormatter colorPatternFormatter = new ColorPatternFormatter(config.console.darken, config.console.format);
            } else {
                PatternFormatter patternFormatter = new PatternFormatter(config.console.format);
            }
            handler = new ConsoleHandler((Formatter)var9_14);
            handler.setLevel(config.console.level);
            handler.setErrorManager((ErrorManager)errorManager);
            handler.setFilter((Filter)new LogCleanupFilter(filterElements));
            handlers.add(handler);
            errorManager = handler.getLocalErrorManager();
        }
        if (config.file.enable) {
            PatternFormatter patternFormatter = new PatternFormatter(config.file.format);
            handler = new FileHandler((Formatter)patternFormatter);
            handler.setAppend(true);
            try {
                handler.setFile(config.file.path);
            }
            catch (FileNotFoundException e) {
                errorManager.error("Failed to set log file", e, 4);
            }
            handler.setErrorManager((ErrorManager)errorManager);
            handler.setLevel(config.file.level);
            handler.setFilter((Filter)new LogCleanupFilter(filterElements));
            handlers.add(handler);
        }
        InitialConfigurator.DELAYED_HANDLER.setHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    public void initializeLoggingForImageBuild() {
        if (ImageInfo.inImageBuildtimeCode()) {
            ConsoleHandler handler = new ConsoleHandler((Formatter)new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{1.}] %s%e%n"));
            handler.setLevel(Level.INFO);
            InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{handler});
        }
    }
}

