/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.ConfigItem;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConfigInstantiator {
    public static void handleObject(Object o) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        Class<?> cls = o.getClass();
        String name = ConfigInstantiator.dashify(cls.getSimpleName().substring(0, cls.getSimpleName().length() - "Config".length()));
        ConfigInstantiator.handleObject("quarkus." + name, o, config);
    }

    private static void handleObject(String prefix, Object o, SmallRyeConfig config) {
        try {
            Class<?> cls = o.getClass();
            if (!cls.getName().endsWith("Config")) {
                return;
            }
            for (Field field : cls.getFields()) {
                Optional val;
                ConfigItem configItem = field.getDeclaredAnnotation(ConfigItem.class);
                if (configItem == null) {
                    Object newInstance = field.getType().newInstance();
                    field.set(o, newInstance);
                    ConfigInstantiator.handleObject(prefix + "." + ConfigInstantiator.dashify(field.getName()), newInstance, config);
                    continue;
                }
                String name = configItem.name();
                if (name.equals("<<hyphenated element name>>")) {
                    name = ConfigInstantiator.dashify(field.getName());
                }
                String fullName = prefix + "." + name;
                String defaultValue = configItem.defaultValue();
                if (defaultValue.equals("<<no default>>")) {
                    defaultValue = null;
                }
                if ((val = config.getOptionalValue(fullName, field.getType())).isPresent()) {
                    field.set(o, val.get());
                    continue;
                }
                if (defaultValue != null) {
                    if (field.getType().equals(List.class)) {
                        Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        String[] parts = defaultValue.split(",");
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (String i : parts) {
                            list.add(config.convert(i, listType));
                        }
                        field.set(o, list);
                        continue;
                    }
                    if (field.getType().equals(Optional.class)) {
                        Class optionalType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        field.set(o, Optional.of(config.convert(defaultValue, optionalType)));
                        continue;
                    }
                    field.set(o, config.convert(defaultValue, field.getType()));
                    continue;
                }
                if (field.getType().equals(Optional.class)) {
                    field.set(o, Optional.empty());
                    continue;
                }
                if (field.getType().equals(OptionalInt.class)) {
                    field.set(o, OptionalInt.empty());
                    continue;
                }
                if (field.getType().equals(OptionalDouble.class)) {
                    field.set(o, OptionalDouble.empty());
                    continue;
                }
                if (!field.getType().equals(OptionalLong.class)) continue;
                field.set(o, OptionalLong.empty());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String dashify(String substring) {
        StringBuilder ret = new StringBuilder();
        for (char i : substring.toCharArray()) {
            if (i >= 'A' && i <= 'Z') {
                ret.append('-');
            }
            ret.append(Character.toLowerCase(i));
        }
        return ret.toString();
    }
}

