/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.runtime.annotations.Template;
import io.quarkus.runtime.logging.CategoryConfig;
import io.quarkus.runtime.logging.CleanupFilterConfig;
import io.quarkus.runtime.logging.FileConfig;
import io.quarkus.runtime.logging.InitialConfigurator;
import io.quarkus.runtime.logging.LogCleanupFilter;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogConfig;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;
import org.jboss.logmanager.handlers.PeriodicSizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;

@Template
public class LoggingSetupTemplate {
    /*
     * WARNING - void declaration
     */
    public void initializeLogging(LogConfig config) {
        Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        Object errorManager = new OnlyOnceErrorManager();
        rootLogger.setLevel(config.level.orElse(Level.INFO));
        for (Map.Entry<String, CategoryConfig> entry : categories.entrySet()) {
            String name = entry.getKey();
            Logger logger = logContext.getLogger(name);
            CategoryConfig categoryConfig = entry.getValue();
            if ("inherit".equals(categoryConfig.level)) continue;
            logger.setLevelName(categoryConfig.level);
        }
        Map<String, CleanupFilterConfig> filters = config.filters;
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size());
        for (Map.Entry entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement((String)entry.getKey(), ((CleanupFilterConfig)entry.getValue()).ifStartsWith));
        }
        ArrayList<Object> handlers = new ArrayList<Object>(2);
        if (config.console.enable) {
            void var9_14;
            if (config.console.color && System.console() != null) {
                ColorPatternFormatter colorPatternFormatter = new ColorPatternFormatter(config.console.darken, config.console.format);
            } else {
                PatternFormatter patternFormatter = new PatternFormatter(config.console.format);
            }
            ConsoleHandler handler = new ConsoleHandler((Formatter)var9_14);
            handler.setLevel(config.console.level);
            handler.setErrorManager((ErrorManager)errorManager);
            handler.setFilter((Filter)new LogCleanupFilter(filterElements));
            if (config.console.async.enable) {
                AsyncHandler asyncHandler = new AsyncHandler(config.console.async.queueLength);
                asyncHandler.setOverflowAction(config.console.async.overflow);
                asyncHandler.addHandler((Handler)handler);
                asyncHandler.setLevel(config.console.level);
                handlers.add(asyncHandler);
            } else {
                handlers.add(handler);
            }
            errorManager = handler.getLocalErrorManager();
        }
        if (config.file.enable) {
            void var9_20;
            FileHandler fileHandler = new FileHandler();
            FileConfig.RotationConfig rotationConfig = config.file.rotation;
            if (rotationConfig.maxFileSize.isPresent() && rotationConfig.fileSuffix.isPresent()) {
                PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler = new PeriodicSizeRotatingFileHandler();
                periodicSizeRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
                periodicSizeRotatingFileHandler.setRotateSize(rotationConfig.maxFileSize.get().asLongValue());
                periodicSizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
                periodicSizeRotatingFileHandler.setMaxBackupIndex(rotationConfig.maxBackupIndex);
                PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler2 = periodicSizeRotatingFileHandler;
            } else if (rotationConfig.maxFileSize.isPresent()) {
                SizeRotatingFileHandler sizeRotatingFileHandler = new SizeRotatingFileHandler(rotationConfig.maxFileSize.get().asLongValue(), rotationConfig.maxBackupIndex);
                sizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
                SizeRotatingFileHandler sizeRotatingFileHandler2 = sizeRotatingFileHandler;
            } else if (rotationConfig.fileSuffix.isPresent()) {
                PeriodicRotatingFileHandler periodicRotatingFileHandler = new PeriodicRotatingFileHandler();
                periodicRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
                PeriodicRotatingFileHandler periodicRotatingFileHandler2 = periodicRotatingFileHandler;
            }
            PatternFormatter formatter = new PatternFormatter(config.file.format);
            var9_20.setFormatter((Formatter)formatter);
            var9_20.setAppend(true);
            try {
                var9_20.setFile(config.file.path);
            }
            catch (FileNotFoundException e) {
                errorManager.error("Failed to set log file", e, 4);
            }
            var9_20.setErrorManager((ErrorManager)errorManager);
            var9_20.setLevel(config.file.level);
            var9_20.setFilter((Filter)new LogCleanupFilter(filterElements));
            if (config.file.async.enable) {
                AsyncHandler asyncHandler = new AsyncHandler(config.file.async.queueLength);
                asyncHandler.setOverflowAction(config.file.async.overflow);
                asyncHandler.addHandler((Handler)var9_20);
                asyncHandler.setLevel(config.file.level);
                handlers.add(asyncHandler);
            } else {
                handlers.add(var9_20);
            }
        }
        InitialConfigurator.DELAYED_HANDLER.setHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    public void initializeLoggingForImageBuild() {
        if (ImageInfo.inImageBuildtimeCode()) {
            ConsoleHandler handler = new ConsoleHandler((Formatter)new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{1.}] %s%e%n"));
            handler.setLevel(Level.INFO);
            InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{handler});
        }
    }
}

