/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import java.math.BigDecimal;
import org.jboss.logging.Logger;

public class Timing {
    private static volatile long bootStartTime = -1L;
    private static volatile long bootStopTime = -1L;
    private static volatile String httpServerInfo = "";
    private static final String UNSET_VALUE = "<<unset>>";

    public static void staticInitStarted() {
        if (bootStartTime < 0L) {
            bootStartTime = System.nanoTime();
        }
    }

    public static void staticInitStopped() {
        if (bootStopTime < 0L) {
            bootStopTime = System.nanoTime();
        }
    }

    public static void setHttpServer(String info) {
        httpServerInfo = info;
    }

    public static void mainStarted() {
    }

    public static void restart() {
        bootStartTime = System.nanoTime();
    }

    public static void printStartupTime(String name, String version, String quarkusVersion, String features, String profile, boolean liveCoding) {
        String safeAppVersion;
        long bootTimeNanoSeconds = System.nanoTime() - bootStartTime;
        Logger logger = Logger.getLogger((String)"io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(bootTimeNanoSeconds);
        String safeAppName = name == null || name.isEmpty() ? UNSET_VALUE : name;
        String string = safeAppVersion = version == null || version.isEmpty() ? UNSET_VALUE : version;
        if (UNSET_VALUE.equals(safeAppName) || UNSET_VALUE.equals(safeAppVersion)) {
            logger.infof("Quarkus %s started in %ss. %s", (Object)quarkusVersion, (Object)secondsRepresentation, (Object)httpServerInfo);
        } else {
            logger.infof("%s %s (running on Quarkus %s) started in %ss. %s", new Object[]{name, version, quarkusVersion, secondsRepresentation, httpServerInfo});
        }
        logger.infof("Profile %s activated. %s", (Object)profile, (Object)(liveCoding ? "Live Coding activated." : ""));
        logger.infof("Installed features: [%s]", (Object)features);
        bootStartTime = -1L;
    }

    public static void printStopTime() {
        long stopTimeNanoSeconds = System.nanoTime() - bootStopTime;
        Logger logger = Logger.getLogger((String)"io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(stopTimeNanoSeconds);
        logger.infof("Quarkus stopped in %ss", (Object)secondsRepresentation);
        bootStopTime = -1L;
    }

    public static BigDecimal convertToBigDecimalSeconds(long timeNanoSeconds) {
        BigDecimal secondsRepresentation = BigDecimal.valueOf(timeNanoSeconds).divide(BigDecimal.valueOf(1000000L), 4).divide(BigDecimal.valueOf(1000L), 3, 4);
        return secondsRepresentation;
    }
}

